# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::Widget::ArchiveRegistry::Query;

use base qw(Gtk2::Table);

use Glib qw(TRUE FALSE);
use Gtk2;

sub new ($$$) {
	my $class = shift;
	my $window = shift || die "No window given";
	my $registry = shift || die "No registry given";

	my $self = bless Gtk2::Table->new(3, 2), $class;

	$self->{window} = $window;
	$self->{registry} = $registry;
	$self->_init;

	return $self;
}

sub _init ($) {
	my $self = shift;

	$self->set_border_width(8);
	$self->set_row_spacings(2);
	$self->set_col_spacings(10);

	my $label1 = Gtk2::Label->new("Archive regexp:");
	my $entry1 = Gtk2::Entry->new; $entry1->set_text(".*");
	my $label2 = Gtk2::Label->new("Version regexp:");
	my $entry2 = Gtk2::Entry->new; $entry2->set_text("archway");
	my $button = Gtk2::Button->new(" Search ");

	$self->attach($label1, 0, 1, 0, 1, [ 'fill' ], [ 'fill' ], 0, 0);
	$self->attach($entry1, 1, 2, 0, 1, [ 'fill' ], [ 'fill' ], 0, 0);
	$self->attach($label2, 0, 1, 1, 2, [ 'fill' ], [ 'fill' ], 0, 0);
	$self->attach($entry2, 1, 2, 1, 2, [ 'fill' ], [ 'fill' ], 0, 0);
	$self->attach($button, 2, 3, 0, 1, [ 'fill' ], [ 'fill' ], 0, 0);

	$label1->set_alignment(0.0, 0.5);
	$label2->set_alignment(0.0, 0.5);
	$button->set_alignment(1.0, 0.5);

	$self->{entry1} = $entry1;
	$self->{entry2} = $entry2;
	$self->{button} = $button;

	$self->show_all;
}

sub signal_clicked_connect ($$) {
	my $self = shift;
	my $code = shift;
	$self->{button}->signal_connect(clicked => $code);
}

sub archive_re ($) {
	my $self = shift;
	return $self->{entry1}->get_text;
}

sub version_re ($) {
	my $self = shift;
	return $self->{entry2}->get_text;
}

1;

__END__
