// -*- c++ -*-
//  Generated by gtkmmproc from ./../progress.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_PROGRESS_H
#define _GTKMM_PROGRESS_H

/* $Id: progress.h,v 1.2 2003/06/17 16:37:41 pbd Exp $ */

/* progress.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/widget.h>
#include <gtk/gtkprogress.h>

// m4 sucks up a name we want.

namespace Gtk {
class Progress;
class Progress_Class;
}
namespace Gtk { Gtk::Progress *wrap (GtkProgress *o); }
namespace Gtk
{
class Adjustment;

//: The base class for {\class Gtk::ProgressBar}.
//- A {\class Gtk::Progress} is the abstract base class used to derive a
//- {\class Gtk::ProgressBar} which provides a visual representation of
//- the progress of a long running operation.
class Progress : public Widget {

public:
  typedef Progress          CppObjectType;
  typedef Progress_Class    CppClassType;
  typedef GtkProgress           BaseObjectType;
  typedef GtkProgressClass      BaseClassType;

private:
  friend class Progress_Class;
  static CppClassType progress_class;

  Progress(const Progress&);
  Progress& operator=(const Progress&); // not implemented

protected:
  void   initialize_class();
  explicit Progress(GtkProgress *castitem);

public:
  static GtkType get_type();
  GtkProgress* gtkobj()             { return (GtkProgress*)(gtkobject); }
  const GtkProgress* gtkobj() const { return (GtkProgress*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~Progress();

private:

public:

  // Gtk_Progress(); No such constructor. It's a kind of handle class



  //: Controls whether progress text is shown.
  //- show_text: A boolean indicating whether the progress text is shown.

  void set_show_text(bool show_text);

  //: Controls the alignment of the text within the progress bar area.
  //- x_align: A number between 0.0 and 1.0 indicating the horizontal
  //- alignment of the progress text within the {\class Gtk::Progress}.
  //-
  //- y_align: A number between 0.0 and 1.0 indicating the vertical
  //- alignment of the progress text within the {\class Gtk::Progress}.

  void set_text_alignment(gfloat x_align,gfloat y_align);

  //: Sets a format string used to display text indicating the current progress.
  //- format: A string used to display progress text. The string can contain the following substitution characters:
  //-
  //- %v - the current progress value.
  //-
  //- %l - the lower bound for the progress value.
  //-
  //- %u - the upper bound for the progress value.
  //-
  //- %p - the current progress percentage.
  //-
  void set_format_string(const string& format); // Use WRAP_METHOD
 // when gtk_progress_set_format_string is fixed to take a const char*

  Gtk::Adjustment* get_adjustment() const;
  //: Associates a {\class Gtk::Adjustment} with the {\class Gtk::Progress}.
  //- A {\class Gtk::Adjustment} is used to represent the upper and lower bounds
  //- and the step interval of the underlying value for which progress is shown.
  //-
  //- adjustment: The {\class Gtk::Adjustment} to be associated with the {\class Gtk::Progress}.


  void set_adjustment(Gtk::Adjustment& adjustment);



  void set_adjustment(Gtk::Adjustment* adjustment=0);

  //: Allows the configuration of the minimum, maximum, and current values for the {\class Gtk::Progress}.
  //- value: The current progress value.
  //-
  //- min: The minimum progress value.
  //-
  //- max: The maximum progress value.

  void configure(gfloat value,gfloat min,gfloat max);

  //: Sets the current percentage completion for the {\class Gtk::Progress}.
  //- percentage: The percentage complete which must be between 0.0 and 1.0.

  void set_percentage(gfloat percentage);

  //: Sets the value within the {\class Gtk::Progress} to an absolute value.
  //- The value must be within the valid range of values for the underlying {\class Gtk::Adjustment}.
  //-
  //- value: The value indicating the current completed amount.

  void set_value(gfloat value);

  //: Returns the current progress complete value.
  //- Returns: The current progress complete value.

  gfloat get_value() const;

  //: A {\class Gtk::Progress} can be in one of two different modes: percentage
  //- mode (the default) and activity mode. In activity mode, the progress is
  //- simply indicated as activity rather than as a percentage complete.
  //-
  //- activity_mode: A boolean, TRUE for activity mode.

  void set_activity_mode(bool activity_mode);

  //: Returns the current text associated with the {\class Gtk::Progress}.
  //- This text is the based on the underlying format string after any substitutions are made.
  //-
  //- Returns: The text indicating the current progress.

  string get_current_text() const;

  //: Returns the text indicating the progress based on the supplied value.
  //- The current value for the {\class Gtk::Progress} remains unchanged.
  //-
  //- value: An absolute progress value to use when formatting the progress text.
  //-
  //- Returns: A string indicating the progress.

  string get_text_from_value(gfloat value) const;

  //: Returns the current progress as a percentage.
  //- Returns: A number between 0.0 and 1.0 indicating the percentage complete.

  gfloat get_current_percentage() const;

  //: Returns the progress as a percentage calculated from the supplied absolute progress value.
  //- value: An absolute progress value.
  //-
  //- Returns: a number between 0.0 and 1.0 indicating the percentage complete represented by value.

  gfloat get_percentage_from_value(gfloat value) const;

public:

  union
    {
      CppObjectType * progress_self;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,0> paint;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,1> update;
      Gtk::ProxySignal0<void,CppObjectType,BaseObjectType,2> act_mode_enter;
    };

protected:
  // impl functions
    virtual void paint_impl();
    virtual void update_impl();
    virtual void act_mode_enter_impl();

};

}


//+ PROPERTIES(Gtk_Progress)
//. name: adjustment
//. type: GtkAdjustment*
//. get:
//. set:
//. desc:

//. name: offscreen_pixmap
//. type: GdkPixmap*
//. get:
//. set:
//. desc:

//. name: format
//. type: string
//. get:
//. set:
//. desc:

//. name: x_align
//. type: gfloat
//. get:
//. set:
//. desc:

//. name: y_align
//. type: gfloat
//. get:
//. set:
//. desc:

//. name: show_text
//. type: guint:1
//. get:
//. set:
//. desc:

//. name: activity_mode
//. type: guint:1
//. get:
//. set:
//. desc:

#endif
