#ifndef __gtk_ardour_xfade_edit_h__
#define __gtk_ardour_xfade_edit_h__

#include <list>

#include <gtk--/window.h>
#include <gtk--/box.h>
#include <gtk--/button.h>
#include <gtk--/radiobutton.h>
#include <gtk-canvas/gtk-canvas.h>

#include <ardour/curve.h>

namespace ARDOUR
{
	class Session;
	class Curve;
	class Crossfade;
}

class CrossfadeEditor : public Gtk::Window
{
  public:
    CrossfadeEditor (ARDOUR::Session&, ARDOUR::Crossfade&, double miny, double maxy);
    ~CrossfadeEditor ();
    
    void apply ();

    static const double canvas_border;
    
    /* these are public so that a caller/subclass can make them do the right thing.
     */
    
    Gtk::Button cancel_button;
    Gtk::Button ok_button;

    struct PresetPoint {
	double x;
	double y;
	
	PresetPoint (double a, double b) 
		: x (a), y (b) {}
    };

    typedef list<PresetPoint> Preset;
    typedef list<Preset*> Presets;

    static Presets* presets;

  private:
    ARDOUR::Crossfade& xfade;
    ARDOUR::Session& session;

    Gtk::VBox vpacker;

    struct Point {
	~Point();

	GtkCanvasItem* box;
	GtkCanvasItem* curve;
	double x;
	double y;

	static const int size;

	void move_to (double x, double y, double xfract, double yfract);
    };

    struct PointSorter 
    {
	bool operator() (const CrossfadeEditor::Point* a, const CrossfadeEditor::Point *b) {
		return a->x < b->x;
	}
    };

    GtkWidget*    _canvas;
    GtkCanvasItem* toplevel;
    Gtk::Widget*   canvas;

    struct Half {
	GtkCanvasItem*          line;
	list<Point*>            points;
	ARDOUR::Curve           normative_curve; /* 0 - 1.0, linear */
	ARDOUR::Curve           gain_curve;      /* 0 - 2.0, gain mapping */
	vector<GtkCanvasItem*>  waves;

	Half();
    };

    enum WhichFade {
	    In = 0,
	    Out = 1
    };

    Half fade[2];
    WhichFade current;

    bool point_grabbed;

    Gtk::HBox preset_upper_box;
    Gtk::HBox preset_lower_box;
    Gtk::HBox action_box;

    Gtk::VBox vpacker2;

    Gtk::Button clear_button;
    Gtk::Button revert_button;

    Gtk::ToggleButton audition_button;

    gint event_handler (GdkEvent*);

    static gint _canvas_event (GtkCanvasItem*, GdkEvent* event, gpointer data);
    static gint _point_event (GtkCanvasItem*, GdkEvent* event, gpointer data);
    static gint _curve_event (GtkCanvasItem*, GdkEvent* event, gpointer data);

    gint canvas_event (GtkCanvasItem*, GdkEvent* event);
    gint point_event (GtkCanvasItem*, GdkEvent* event);
    gint curve_event (GtkCanvasItem*, GdkEvent* event);

    void canvas_allocation (GtkAllocation*);
    void add_control_point (double x, double y);
    Point* make_point ();
    void redraw ();
    
    double effective_width () const { return _canvas->allocation.width - (2.0 * canvas_border); }
    double effective_height () const { return _canvas->allocation.height - (2.0 * canvas_border); }

    void clear ();
    void reset ();

    double miny;
    double maxy;

    static Preset* s_in_preset;
    static Preset* s_out_preset;
    static Preset* midpoint_in_preset;
    static Preset* midpoint_out_preset;

    void build_presets ();
    void apply_preset (Preset*);
    
    Gtk::RadioButton select_in_button;
    Gtk::RadioButton select_out_button;
    Gtk::HBox   curve_button_box;

    void curve_select_clicked (WhichFade);

    double x_coordinate (double& xfract) const;
    double y_coordinate (double& yfract) const;
    
    void set (const ARDOUR::Curve& alist, WhichFade);

    void make_waves (ARDOUR::AudioRegion&, WhichFade);
    void peaks_ready (ARDOUR::AudioRegion* r, WhichFade);
    
    void _apply_to (ARDOUR::Crossfade* xf);
    void setup (ARDOUR::Crossfade*);
    void audition_toggled ();
    void audition ();
    void cancel_audition ();
    void audition_state_changed (bool);

};

#endif /* __gtk_ardour_xfade_edit_h__ */
