/*
    Copyright (C) 2000 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: editor_cursors.cc,v 1.13 2004/02/11 19:11:39 pauld Exp $
*/

#include <cstdlib>
#include <cmath>

#include <gtk-canvas.h>

#include "editor.h"

using namespace SigC;
using namespace ARDOUR;
using namespace Gtk;

Editor::Cursor::Cursor (Editor& ed, const string& color, GtkSignalFunc callbck)
	: editor (ed), callback (callbck), length(1.0)
{
	GtkCanvasGroup *group;
	points = gtk_canvas_points_new (2);
	
	/* "randomly" initialize coords */

	points->coords[0] = -9383839.0;
	points->coords[1] = 0.0;
	points->coords[2] = 1.0;
	points->coords[3] = 0.0;

	group = GTK_CANVAS_GROUP (editor.cursor_group);

	canvas_item = gtk_canvas_item_new (group,
					   gtk_canvas_line_get_type(),
					   "points", points,
					   "fill_color", color.c_str(),
					   "width_pixels", 1,
					   "first_arrowhead", (gboolean) TRUE,
					   "last_arrowhead", (gboolean) TRUE,
					   "arrow_shape_a", 8.0,
					   "arrow_shape_b", 0.0,
					   "arrow_shape_c", 7.0,
					   NULL);

	// cerr << "cursor line @ " << canvas_item << endl;

	gtk_object_set_data (GTK_OBJECT(canvas_item), "cursor", this);
	gtk_signal_connect (GTK_OBJECT(canvas_item), "event", callback, &editor);

	current_frame = 1; /* force redraw at 0 */
}

Editor::Cursor::~Cursor ()

{
	gtk_object_destroy (GTK_OBJECT(canvas_item));
	gtk_canvas_points_unref (points);
}

void
Editor::Cursor::set_position (jack_nframes_t frame)
{
	double new_pos =  editor.frame_to_unit (frame);

	if (editor.session == 0) {
		gtk_canvas_item_hide (canvas_item);
	} else {
		gtk_canvas_item_show (canvas_item);
	}

	current_frame = frame;

	if (new_pos == points->coords[0]) {

		/* change in position is not visible, so just raise it */
		
		gtk_canvas_item_raise_to_top (canvas_item);
		return;
	} 

	points->coords[0] = new_pos;
	points->coords[2] = new_pos;

	gtk_canvas_item_set (canvas_item, "points", points, NULL);
	gtk_canvas_item_raise_to_top (canvas_item);
}

void
Editor::Cursor::set_length (double units)
{
	length = units; 
	points->coords[3] = points->coords[1] + length;
	gtk_canvas_item_set (canvas_item, "points", points, NULL);
}

void 
Editor::Cursor::set_y_axis (double position)
{
	points->coords[1] = position;
	points->coords[3] = position + length;
	gtk_canvas_item_set (canvas_item, "points", points, NULL);
}
