/*
    Copyright (C) 2001 Paul Davis
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: opts.cc,v 1.18 2004/02/22 23:04:00 taybin Exp $
*/

#include <getopt.h>
#include <iostream>
#include <cstdlib>

#include "opts.h"

#include "i18n.h"

string GTK_ARDOUR::ui_rcfile = "";
string GTK_ARDOUR::session_name = "";
string GTK_ARDOUR::jack_client_name = "ardour";
bool  GTK_ARDOUR::show_key_actions = false;
bool GTK_ARDOUR::no_splash = false;
bool GTK_ARDOUR::just_version = false;

using namespace GTK_ARDOUR;

int
print_help (const char *execname)
{
	cout << _("Usage: ") << execname << "\n"
	     << _("  -v, --version                    Show version information\n")
	     << _("  -h, --help                       Print this message\n")
	     << _("  -b, --bindings                   Print all possible keyboard binding names\n")
	     << _("  -n, --no-splash                  Don't show splash screen\n")
	     << _("  -U, --ui-rcfile  path            Use a specific UI style file\n")
	     << _("  -c, --jack-client-name  name     Use a specific jack client name, default is ardour\n")
	     << _("  [session-name]                   Name of session to load\n")
		;
	return 1;

}

int
GTK_ARDOUR::parse_opts (int argc, char *argv[])

{
	const char *optstring = "U:hbvnc:";
	const char *execname = strrchr (argv[0], '/');

	if (execname == 0) {
		execname = argv[0];
	} else {
		execname++;
	}

	const struct option longopts[] = {
		{ "version", 0, 0, 'v' },
		{ "ui-rcfile", 1, 0, 'U' },
		{ "help", 0, 0, 'h' },
		{ "bindings", 0, 0, 'b' },
		{ "no-splash", 0, 0, 'n' },
		{ "jack-client-name", 1, 0, 'c' },
		{ 0, 0, 0, 0 }
	};

	int option_index = 0;
	int c = 0;

	while (1) {
		c = getopt_long (argc, argv, optstring, longopts, &option_index);

		if (c == -1) {
			break;
		}

		switch (c) {
		case 0:
			break;

		case 'v':
			just_version = true;
			break;

		case 'h':
			print_help (execname);
			exit (0);
			break;
		case 'b':
			show_key_actions = true;
			break;

		case 'n':
			no_splash = true;
			break;

		case 'U':
			ui_rcfile = optarg;
			break;

		case 'c':
			jack_client_name = optarg;
			break;

		default:
			break;
		}
	}

	if (optind < argc) {
		session_name = argv[optind++];
	}

	return 0;
}

