/*
    Copyright (C) 2000 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: plugin_manager.h,v 1.8 2003/04/23 02:35:41 pbd Exp $
*/

#ifndef __ardour_plugin_manager_h__
#define __ardour_plugin_manager_h__

#include <gtk--.h>
#include <gtkmmext/selector.h>

#include <ardour_dialog.h>

namespace ARDOUR {
	class Session;
}

namespace LADSPA {
	class Manager;
	class Plugin;
}

class PluginManager : public ArdourDialog 
{
  public:
	PluginManager (LADSPA::Manager *);
	SigC::Signal1<void,LADSPA::Plugin *> PluginCreated;

	void set_session (ARDOUR::Session*);

  private:
	ARDOUR::Session* session;
	Gtkmmext::Selector i_selector;
	Gtkmmext::Selector o_selector;
	
	// We need a string for the input side because plugins
	// are loaded by name.
	string i_selected_plug;

	// We need an integer for the output side because
	// the name isn't promised to be unique.
	gint o_selected_plug;

	LADSPA::Manager *ladspa;
	list<string> added_plugins;

	static void _input_refiller (Gtk::CList &, void *);
	static void _output_refiller (Gtk::CList &, void *);

	void input_refiller (Gtk::CList &);
	void output_refiller (Gtk::CList &);
	void i_plugin_selected (Gtkmmext::Selector *selector,
			      Gtkmmext::SelectionResult *res);
	void i_plugin_chosen (Gtkmmext::Selector *selector,
			    Gtkmmext::SelectionResult *res);
	void o_plugin_selected (Gtkmmext::Selector *selector,
			      Gtkmmext::SelectionResult *res);
	void o_plugin_chosen (Gtkmmext::Selector *selector,
			    Gtkmmext::SelectionResult *res);
	
	void btn_add_clicked();
	void btn_remove_clicked();
	void btn_ok_clicked();
	void btn_update_clicked();
	void btn_apply_clicked();
	void btn_cancel_clicked();
	void use_plugin (string name);
	gint wm_close(GdkEventAny* ev);
};

#endif /* __ardour_plugin_manager_h__ */
