/*
    Copyright (C) 2003-2004 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: time_selection.cc,v 1.1 2004/02/20 22:00:17 pauld Exp $
*/

#include <pbd/error.h>
#include <ardour/ardour.h>

#include "time_selection.h"

#include "i18n.h"

using namespace ARDOUR;

AudioRange&
TimeSelection::operator[] (unsigned long which)
{
	for (std::list<AudioRange>::iterator i = begin(); i != end(); ++i) {
		if ((*i).id == which) {
			return *i;
		}
	}
	fatal << compose (_("programming error: request for non-existent audio range (%1)!"), which) << endmsg;
	/*NOTREACHED*/
	return *(new AudioRange(0,0,0)); /* keep the compiler happy; never called */
}

jack_nframes_t 
TimeSelection::start ()
{
	if (empty()) {
		return 0;
	}

	jack_nframes_t first = max_frames;

	for (std::list<AudioRange>::iterator i = begin(); i != end(); ++i) {
		if ((*i).start < first) {
			first = (*i).start;
		}
	}
	return first;
}

jack_nframes_t 
TimeSelection::end_frame ()
{
	jack_nframes_t last = 0;

	/* XXX make this work like RegionSelection: no linear search needed */

	for (std::list<AudioRange>::iterator i = begin(); i != end(); ++i) {
		if ((*i).end > last) {
			last = (*i).end;
		}
	}
	return last;
}

jack_nframes_t
TimeSelection::length()
{
	return end_frame() - start() + 1;
}
	
