/*
    Copyright (C) 1999 Paul Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: utils.h,v 1.10 2004/02/22 23:04:01 taybin Exp $
*/

#ifndef __ardour_utils_h__
#define __ardour_utils_h__

#include <iostream>
#include <string>
#include <cmath>
#include <glib.h>

#include "ardour.h"

class XMLNode;

using std::ostream;

void elapsed_time_to_str (char *buf, unsigned long seconds);
string legalize_for_path (std::string str);
ostream& operator<< (ostream& o, const ARDOUR::BBT_Time& bbt);
XMLNode* find_named_node (const XMLNode& node, std::string name);

static inline float f_max(float x, float a) {
	x -= a;
	x += fabs (x);
	x *= 0.5;
	x += a;
	
	return (x);
}

int cmp_nocase (const std::string& s, const std::string& s2);

int tokenize_fullpath (string fullpath, string& path, string& name);

int touch_file(string path);

unsigned long long get_uid();

#endif /* __ardour_utils_h__ */
