#! /usr/bin/python

# converts ardour's old XML presets to the new n3 (rdf) format.
# outputs to stdout.  Either pipe it to a new file in ~/.ladspa/rdf/
# or append it to ~/.ladspa/rdf/ardour-presets.n3.  The choice is yours!

# version 1.3

import time
import os
import os.path
import xml.dom.pulldom

LADSPA_BASE="http://ladspa.org/ontology#"
RDF_BASE="http://www.w3.org/1999/02/22-rdf-syntax-ns#"

counter = 0
lrdf_uid = os.getpid()
lrdf_uid = lrdf_uid ^ long(time.time()*100)

def uuid():
	global counter, lrdf_uid
	uuid = str(lrdf_uid)+"."+str(counter)
	counter = counter + 1
	return uuid

def convert(file, id, name):
	plugin_uri = "<http://ladspa.org/ontology#"+id
	setting_uri = "<http://plugin.org.uk/genid#"+ uuid() +">"

	print plugin_uri+">" + " <"+LADSPA_BASE+"hasSetting>" + " " + setting_uri + " ."
	print setting_uri + " <" + RDF_BASE+"type>" + " <"+LADSPA_BASE+"Preset>" + " ."
	print setting_uri + " <"+LADSPA_BASE+"hasLabel>" + " " + "\"" + name + "\"" + " ."

	doc = xml.dom.pulldom.parse(file)
	for event, node in doc:
		if event=='START_ELEMENT' and node.nodeName=='port':
			doc.expandNode(node)
			number = node.getAttribute('number')
			value  = node.getAttribute('value')

			value_uri = "<http://plugin.org.uk/genid#"+uuid()+">"
			port_uri = plugin_uri +"."+ number + ">"
			value_lit = "\""+value+"\""
			
			print setting_uri + " " + "<"+LADSPA_BASE+"hasPortValue>" + " " + value_uri + " ."
			print value_uri + " " + "<"+RDF_BASE+"value>" + " " + value_lit + " ."
			print value_uri + " " + "<"+LADSPA_BASE+"forPort>" + " " + port_uri + " ."

home_dir = os.path.expandvars("$HOME")
preset_dir = home_dir + "/.ardour/presets/"
plugin_dirs = os.listdir(preset_dir)

for plugin_id in plugin_dirs:
	presets = os.listdir(preset_dir+"/"+plugin_id)
	for preset in presets:
		filename = preset_dir+"/"+plugin_id+"/"+preset
		convert(filename, plugin_id, preset[:-4])

