/* Helpers.c generated by valac, the Vala compiler
 * generated from Helpers.vala, do not modify */

/* 
    Copyright 2009 by Hans Baier
    License: LGPLv2+ 
*/

#include "gtkmm2ext/prolooks-helpers.h"

static gpointer cairo_color_parent_class = NULL;
static gpointer prolooks_hsl_parent_class = NULL;
static gpointer prolooks_hsv_parent_class = NULL;

CairoColor* cairo_color_construct (GType object_type, double red, double green, double blue, double alpha) {
	CairoColor* self;
	self = (CairoColor*) g_type_create_instance (object_type);
	cairo_color_set_red (self, red);
	cairo_color_set_green (self, green);
	cairo_color_set_blue (self, blue);
	cairo_color_set_alpha (self, alpha);
	return self;
}


CairoColor* cairo_color_new (double red, double green, double blue, double alpha) {
	return cairo_color_construct (CAIRO_TYPE_COLOR, red, green, blue, alpha);
}


CairoColor* cairo_color_copy (CairoColor* self) {
	CairoColor* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = cairo_color_new (self->priv->_red, self->priv->_green, self->priv->_blue, self->priv->_alpha);
	return result;
}


CairoColor* cairo_color_construct_from_string (GType object_type, const char* webcolor) {
	CairoColor* self;
	g_return_val_if_fail (webcolor != NULL, NULL);
	self = (CairoColor*) g_type_create_instance (object_type);
	cairo_color_set_from_string (self, webcolor);
	return self;
}


CairoColor* cairo_color_new_from_string (const char* webcolor) {
	return cairo_color_construct_from_string (CAIRO_TYPE_COLOR, webcolor);
}


CairoColor* cairo_color_shade (CairoColor* self, double shade_factor) {
	CairoColor* result = NULL;
	ProlooksHSL* hsl;
	g_return_val_if_fail (self != NULL, NULL);
	hsl = prolooks_hsl_new ();
	prolooks_hsl_from_cairo_color (hsl, self);
	prolooks_hsl_set_lightness (hsl, fmin (prolooks_hsl_get_lightness (hsl) * shade_factor, 1.0));
	prolooks_hsl_set_lightness (hsl, fmax (prolooks_hsl_get_lightness (hsl), 0.0));
	prolooks_hsl_set_saturation (hsl, fmin (prolooks_hsl_get_saturation (hsl) * shade_factor, 1.0));
	prolooks_hsl_set_saturation (hsl, fmax (prolooks_hsl_get_saturation (hsl), 0.0));
	result = prolooks_hsl_to_cairo_color (hsl);
	_prolooks_hsl_unref0 (hsl);
	return result;
}


void cairo_color_set_to (CairoColor* self, CairoColor* a_color) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a_color != NULL);
	cairo_color_set_red (self, a_color->priv->_red);
	cairo_color_set_green (self, a_color->priv->_green);
	cairo_color_set_blue (self, a_color->priv->_blue);
	cairo_color_set_alpha (self, a_color->priv->_alpha);
}


void cairo_color_set_as_source_in (CairoColor* self, cairo_t* cr) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_set_source_rgba (cr, self->priv->_red, self->priv->_green, self->priv->_blue, self->priv->_alpha);
}


void cairo_color_add_color_stop_to (CairoColor* self, cairo_pattern_t* p, double offset) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	cairo_pattern_add_color_stop_rgba (p, offset, self->priv->_red, self->priv->_green, self->priv->_blue, self->priv->_alpha);
}


void cairo_color_set_from_string (CairoColor* self, const char* webcolor) {
	CairoColor* _tmp2_;
	GdkColor _tmp1_;
	GdkColor _tmp0_ = {0,0,0,0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (webcolor != NULL);
	cairo_color_set_to (self, _tmp2_ = prolooks_gdk_color_to_cairo ((_tmp1_ = (prolooks_color_from_string (webcolor, &_tmp0_), _tmp0_), &_tmp1_)));
	_cairo_color_unref0 (_tmp2_);
}


double cairo_color_get_red (CairoColor* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_red;
	return result;
}


void cairo_color_set_red (CairoColor* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_red = value;
}


double cairo_color_get_green (CairoColor* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_green;
	return result;
}


void cairo_color_set_green (CairoColor* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_green = value;
}


double cairo_color_get_blue (CairoColor* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_blue;
	return result;
}


void cairo_color_set_blue (CairoColor* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_blue = value;
}


double cairo_color_get_alpha (CairoColor* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_alpha;
	return result;
}


void cairo_color_set_alpha (CairoColor* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_alpha = value;
}


static void cairo_value_color_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void cairo_value_color_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		cairo_color_unref (value->data[0].v_pointer);
	}
}


static void cairo_value_color_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = cairo_color_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer cairo_value_color_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* cairo_value_color_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	(void) n_collect_values;
	(void) collect_flags;
	if (collect_values[0].v_pointer) {
		CairoColor* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = cairo_color_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* cairo_value_color_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	CairoColor** object_p;
	(void) n_collect_values;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME ((GValue*)value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = cairo_color_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* cairo_param_spec_color (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	CairoParamSpecColor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CAIRO_TYPE_COLOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer cairo_value_get_color (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE ((GValue*)value, CAIRO_TYPE_COLOR), NULL);
	return value->data[0].v_pointer;
}


void cairo_value_set_color (GValue* value, gpointer v_object) {
	CairoColor* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CAIRO_TYPE_COLOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CAIRO_TYPE_COLOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		cairo_color_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		cairo_color_unref (old);
	}
}


void cairo_value_take_color (GValue* value, gpointer v_object) {
	CairoColor* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CAIRO_TYPE_COLOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CAIRO_TYPE_COLOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		cairo_color_unref (old);
	}
}

static void cairo_color_finalize (CairoColor* obj) {
	CairoColor * self;
	self = CAIRO_COLOR (obj);
}

static void cairo_color_class_init (CairoColorClass * klass) {
	cairo_color_parent_class = g_type_class_peek_parent (klass);
	CAIRO_COLOR_CLASS (klass)->finalize = cairo_color_finalize;
	g_type_class_add_private (klass, sizeof (CairoColorPrivate));
}


static void cairo_color_instance_init (CairoColor * self) {
	self->priv = CAIRO_COLOR_GET_PRIVATE (self);
	self->ref_count = 1;
}



GType cairo_color_get_type (void) {
	static volatile gsize cairo_color_type_id__volatile = 0;
	if (g_once_init_enter (&cairo_color_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { cairo_value_color_init, cairo_value_color_free_value, cairo_value_color_copy_value, cairo_value_color_peek_pointer, "p", cairo_value_color_collect_value, "p", cairo_value_color_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CairoColorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cairo_color_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CairoColor), 0, (GInstanceInitFunc) cairo_color_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType cairo_color_type_id;
		cairo_color_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CairoColor", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&cairo_color_type_id__volatile, cairo_color_type_id);
	}
	return cairo_color_type_id__volatile;
}


gpointer cairo_color_ref (gpointer instance) {
	CairoColor* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void cairo_color_unref (gpointer instance) {
	CairoColor* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CAIRO_COLOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType prolooks_button_state_get_type (void) {
	static volatile gsize prolooks_button_state_type_id__volatile = 0;
	if (g_once_init_enter (&prolooks_button_state_type_id__volatile)) {
		static const GEnumValue values[] = {{PROLOOKS_BUTTON_STATE_NORMAL, "PROLOOKS_BUTTON_STATE_NORMAL", "normal"}, {PROLOOKS_BUTTON_STATE_PRESSED, "PROLOOKS_BUTTON_STATE_PRESSED", "pressed"}, {0, NULL, NULL}};
		GType prolooks_button_state_type_id;
		prolooks_button_state_type_id = g_enum_register_static ("ProlooksButtonState", values);
		g_once_init_leave (&prolooks_button_state_type_id__volatile, prolooks_button_state_type_id);
	}
	return prolooks_button_state_type_id__volatile;
}


GType prolooks_button_type_get_type (void) {
	static volatile gsize prolooks_button_type_type_id__volatile = 0;
	if (g_once_init_enter (&prolooks_button_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PROLOOKS_BUTTON_TYPE_PRESS_BUTTON, "PROLOOKS_BUTTON_TYPE_PRESS_BUTTON", "press-button"}, {PROLOOKS_BUTTON_TYPE_TOGGLE_BUTTON, "PROLOOKS_BUTTON_TYPE_TOGGLE_BUTTON", "toggle-button"}, {0, NULL, NULL}};
		GType prolooks_button_type_type_id;
		prolooks_button_type_type_id = g_enum_register_static ("ProlooksButtonType", values);
		g_once_init_leave (&prolooks_button_type_type_id__volatile, prolooks_button_type_type_id);
	}
	return prolooks_button_type_type_id__volatile;
}


void prolooks_set_line_width_from_device (cairo_t* cr) {
	double ux;
	double uy;
	g_return_if_fail (cr != NULL);
	ux = (double) 1;
	uy = (double) 1;
	cairo_device_to_user (cr, &ux, &uy);
	if (ux < uy) {
		ux = uy;
	}
	cairo_set_line_width (cr, ux);
}


void prolooks_color_from_string (const char* webcolor, GdkColor* result) {
	GdkColor color = {0,0,0,0};
	g_return_if_fail (webcolor != NULL);
	gdk_color_parse (webcolor, &color);
	*result = color;
	return;
}


char* prolooks_color_to_string (const GdkColor* color) {
	char* result = NULL;
	guint16 scale;
	scale = G_MAXUINT16 / G_MAXUINT8;
	result = g_strdup_printf ("#%02x%02x%02x", (guint) ((*color).red / scale), (guint) ((*color).green / scale), (guint) ((*color).blue / scale));
	return result;
}


CairoColor* prolooks_cairo_color_from_string (const char* webcolor) {
	CairoColor* result = NULL;
	GdkColor _tmp1_;
	GdkColor _tmp0_ = {0,0,0,0};
	g_return_val_if_fail (webcolor != NULL, NULL);
	result = prolooks_gdk_color_to_cairo ((_tmp1_ = (prolooks_color_from_string (webcolor, &_tmp0_), _tmp0_), &_tmp1_));
	return result;
}


void prolooks_set_source_color (cairo_t* cr, const GdkColor* color, double alpha) {
	g_return_if_fail (cr != NULL);
	cairo_set_source_rgba (cr, ((double) (*color).red) / ((double) G_MAXUINT16), ((double) (*color).green) / ((double) G_MAXUINT16), ((double) (*color).blue) / ((double) G_MAXUINT16), alpha);
}


void prolooks_gdk_color_to_cairo_color (const GdkColor* color, double* red, double* green, double* blue) {
	*red = ((double) (*color).red) / ((double) G_MAXUINT16);
	*green = ((double) (*color).green) / ((double) G_MAXUINT16);
	*blue = ((double) (*color).blue) / ((double) G_MAXUINT16);
}


CairoColor* prolooks_gdk_color_to_cairo (const GdkColor* color) {
	CairoColor* result = NULL;
	double r;
	double g;
	double b;
	r = (double) 0;
	g = (double) 0;
	b = (double) 0;
	prolooks_gdk_color_to_cairo_color (color, &r, &g, &b);
	result = cairo_color_new (r, g, b, 1.0);
	return result;
}


void prolooks_cairo_color_to_gdk (CairoColor* cairo_color, GdkColor* result) {
	GdkColor color = {0,0,0,0};
	g_return_if_fail (cairo_color != NULL);
	memset (&color, 0, sizeof (GdkColor));
	color.red = (guint16) (cairo_color_get_red (cairo_color) * ((double) G_MAXUINT16));
	color.green = (guint16) (cairo_color_get_green (cairo_color) * ((double) G_MAXUINT16));
	color.blue = (guint16) (cairo_color_get_blue (cairo_color) * ((double) G_MAXUINT16));
	*result = color;
	return;
}


void prolooks_set_source_color_string (cairo_t* cr, const char* color, double alpha) {
	GdkColor _tmp1_;
	GdkColor _tmp0_ = {0,0,0,0};
	g_return_if_fail (cr != NULL);
	g_return_if_fail (color != NULL);
	prolooks_set_source_color (cr, (_tmp1_ = (prolooks_color_from_string (color, &_tmp0_), _tmp0_), &_tmp1_), alpha);
}


void prolooks_add_color_stop (cairo_pattern_t* p, double offset, const GdkColor* color, double alpha) {
	g_return_if_fail (p != NULL);
	cairo_pattern_add_color_stop_rgba (p, offset, ((double) (*color).red) / ((double) G_MAXUINT16), ((double) (*color).green) / ((double) G_MAXUINT16), ((double) (*color).blue) / ((double) G_MAXUINT16), alpha);
}


void prolooks_add_color_stop_str (cairo_pattern_t* p, double offset, const char* color, double alpha) {
	GdkColor _tmp1_;
	GdkColor _tmp0_ = {0,0,0,0};
	g_return_if_fail (p != NULL);
	g_return_if_fail (color != NULL);
	prolooks_add_color_stop (p, offset, (_tmp1_ = (prolooks_color_from_string (color, &_tmp0_), _tmp0_), &_tmp1_), alpha);
}


cairo_pattern_t* prolooks_create_gradient (double x1, double y1, double x2, double y2, const GdkColor* start, const GdkColor* stop, double alpha_start, double alpha_stop) {
	cairo_pattern_t* result = NULL;
	cairo_pattern_t* gradient;
	gradient = cairo_pattern_create_linear (x1, y1, x2, y2);
	prolooks_add_color_stop (gradient, (double) 0, start, alpha_start);
	prolooks_add_color_stop (gradient, (double) 1, stop, alpha_stop);
	result = gradient;
	return result;
}


cairo_pattern_t* prolooks_create_gradient_str (double x1, double y1, double x2, double y2, const char* start, const char* stop, double alpha_start, double alpha_stop) {
	cairo_pattern_t* result = NULL;
	GdkColor _tmp3_;
	GdkColor _tmp2_;
	GdkColor _tmp1_ = {0,0,0,0};
	GdkColor _tmp0_ = {0,0,0,0};
	g_return_val_if_fail (start != NULL, NULL);
	g_return_val_if_fail (stop != NULL, NULL);
	result = prolooks_create_gradient (x1, y1, x2, y2, (_tmp2_ = (prolooks_color_from_string (start, &_tmp0_), _tmp0_), &_tmp2_), (_tmp3_ = (prolooks_color_from_string (stop, &_tmp1_), _tmp1_), &_tmp3_), alpha_start, alpha_stop);
	return result;
}


void prolooks_rounded_rect (cairo_t* cr, double x, double y, double w, double h, double radius_x, double radius_y) {
	double ARC_TO_BEZIER;
	double c1;
	double c2;
	g_return_if_fail (cr != NULL);
	ARC_TO_BEZIER = 0.55228475;
	if (radius_x > (w - radius_x)) {
		radius_x = w / 2;
	}
	if (radius_y > (h - radius_y)) {
		radius_y = h / 2;
	}
	c1 = ARC_TO_BEZIER * radius_x;
	c2 = ARC_TO_BEZIER * radius_y;
	cairo_new_path (cr);
	cairo_move_to (cr, x + radius_x, y);
	cairo_rel_line_to (cr, w - (2 * radius_x), 0.0);
	cairo_rel_curve_to (cr, c1, 0.0, radius_x, c2, radius_x, radius_y);
	cairo_rel_line_to (cr, (double) 0, h - (2 * radius_y));
	cairo_rel_curve_to (cr, 0.0, c2, c1 - radius_x, radius_y, -radius_x, radius_y);
	cairo_rel_line_to (cr, (-w) + (2 * radius_x), (double) 0);
	cairo_rel_curve_to (cr, -c1, (double) 0, -radius_x, -c2, -radius_x, -radius_y);
	cairo_rel_line_to (cr, (double) 0, (-h) + (2 * radius_y));
	cairo_rel_curve_to (cr, 0.0, -c2, radius_x - c1, -radius_y, radius_x, -radius_y);
	cairo_close_path (cr);
}


void prolooks_background_gradient (cairo_t* cr, double w, double h) {
	GdkColor background_gradient_start = {0,0,0,0};
	GdkColor background_gradient_stop = {0,0,0,0};
	cairo_pattern_t* background_gradient;
	g_return_if_fail (cr != NULL);
	gdk_color_parse ("#bebdc2", &background_gradient_start);
	gdk_color_parse ("#b1b4b9", &background_gradient_stop);
	cairo_rectangle (cr, (double) 0, (double) 0, w, h);
	background_gradient = cairo_pattern_create_linear ((double) 0, (double) 0, (double) 0, h);
	prolooks_add_color_stop (background_gradient, (double) 0, &background_gradient_start, 1.0);
	prolooks_add_color_stop (background_gradient, (double) 1, &background_gradient_stop, 1.0);
	cairo_set_source (cr, background_gradient);
	cairo_fill (cr);
	_cairo_pattern_destroy0 (background_gradient);
}


double prolooks_modula (double number, double divisor) {
	double result = 0.0;
	result = (((gint) number) % ((gint) divisor)) + (number - ((gint) number));
	return result;
}


char* prolooks_hsl_to_string (ProlooksHSL* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup_printf ("HSL (%f, %f, %f)", self->priv->_hue, self->priv->_saturation, self->priv->_lightness);
	return result;
}


CairoColor* prolooks_hsl_to_cairo_color (ProlooksHSL* self) {
	CairoColor* result = NULL;
	gint i = 0;
	double* _tmp0_;
	double* hue_shift;
	double* _tmp1_;
	double* color_shift;
	double m1 = 0.0;
	double m2 = 0.0;
	double m3 = 0.0;
	gint _tmp2_ = 0;
	CairoColor* color;
	g_return_val_if_fail (self != NULL, NULL);
	hue_shift = (_tmp0_ = g_new0 (double, 3), _tmp0_);
	color_shift = (_tmp1_ = g_new0 (double, 3), _tmp1_);
	if (self->priv->_lightness <= 0.5) {
		m2 = self->priv->_lightness * (1 + self->priv->_saturation);
	} else {
		m2 = (self->priv->_lightness + self->priv->_saturation) - (self->priv->_lightness * self->priv->_saturation);
	}
	m1 = (2 * self->priv->_lightness) - m2;
	hue_shift[0] = self->priv->_hue + 120;
	hue_shift[1] = self->priv->_hue;
	hue_shift[2] = self->priv->_hue - 120;
	color_shift[0] = color_shift[1] = color_shift[2] = self->priv->_lightness;
	if (self->priv->_saturation == 0) {
		_tmp2_ = 3;
	} else {
		_tmp2_ = 0;
	}
	i = _tmp2_;
	{
		gboolean _tmp3_;
		_tmp3_ = TRUE;
		while (TRUE) {
			if (!_tmp3_) {
				i++;
			}
			_tmp3_ = FALSE;
			if (!(i < 3)) {
				break;
			}
			m3 = hue_shift[i];
			if (m3 > 360) {
				m3 = prolooks_modula (m3, (double) 360);
			} else {
				if (m3 < 0) {
					m3 = 360 - prolooks_modula (fabs (m3), (double) 360);
				}
			}
			if (m3 < 60) {
				color_shift[i] = m1 + (((m2 - m1) * m3) / 60.0);
			} else {
				if (m3 < 180) {
					color_shift[i] = m2;
				} else {
					if (m3 < 240) {
						color_shift[i] = m1 + (((m2 - m1) * (240 - m3)) / 60.0);
					} else {
						color_shift[i] = m1;
					}
				}
			}
		}
	}
	color = cairo_color_new (color_shift[0], color_shift[1], color_shift[2], 1.0);
	result = color;
	hue_shift = (g_free (hue_shift), NULL);
	color_shift = (g_free (color_shift), NULL);
	return result;
}


void prolooks_hsl_to_gdk_color (ProlooksHSL* self, GdkColor* result) {
	GdkColor _tmp1_ = {0,0,0,0};
	CairoColor* _tmp0_;
	GdkColor _tmp2_;
	g_return_if_fail (self != NULL);
	*result = (_tmp2_ = (prolooks_cairo_color_to_gdk (_tmp0_ = prolooks_hsl_to_cairo_color (self), &_tmp1_), _tmp1_), _cairo_color_unref0 (_tmp0_), _tmp2_);
	return;
}


void prolooks_hsl_from_gdk_color (ProlooksHSL* self, const GdkColor* color) {
	CairoColor* _tmp0_;
	g_return_if_fail (self != NULL);
	prolooks_hsl_from_cairo_color (self, _tmp0_ = prolooks_gdk_color_to_cairo (color));
	_cairo_color_unref0 (_tmp0_);
}


void prolooks_hsl_from_cairo_color (ProlooksHSL* self, CairoColor* color) {
	double min = 0.0;
	double max = 0.0;
	double delta = 0.0;
	double red;
	double green;
	double blue;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	red = cairo_color_get_red (color);
	green = cairo_color_get_green (color);
	blue = cairo_color_get_blue (color);
	if (red > green) {
		if (red > blue) {
			max = red;
		} else {
			max = blue;
		}
		if (green < blue) {
			min = green;
		} else {
			min = blue;
		}
	} else {
		if (green > blue) {
			max = green;
		} else {
			max = blue;
		}
		if (red < blue) {
			min = red;
		} else {
			min = blue;
		}
	}
	prolooks_hsl_set_lightness (self, (max + min) / 2.0);
	if (fabs (max - min) < 0.0001) {
		prolooks_hsl_set_hue (self, 0.0);
		prolooks_hsl_set_saturation (self, 0.0);
	} else {
		if (self->priv->_lightness <= 0.5) {
			prolooks_hsl_set_saturation (self, (max - min) / (max + min));
		} else {
			prolooks_hsl_set_saturation (self, (max - min) / ((2.0 - max) - min));
		}
		delta = max - min;
		if (red == max) {
			prolooks_hsl_set_hue (self, (green - blue) / delta);
		} else {
			if (green == max) {
				prolooks_hsl_set_hue (self, 2.0 + ((blue - red) / delta));
			} else {
				if (blue == max) {
					prolooks_hsl_set_hue (self, 4.0 + ((red - green) / delta));
				}
			}
		}
		prolooks_hsl_set_hue (self, self->priv->_hue * 60.0);
		if (self->priv->_hue < 0.0) {
			prolooks_hsl_set_hue (self, self->priv->_hue + 360.0);
		}
	}
}


ProlooksHSL* prolooks_hsl_construct (GType object_type) {
	ProlooksHSL* self;
	self = (ProlooksHSL*) g_type_create_instance (object_type);
	return self;
}


ProlooksHSL* prolooks_hsl_new (void) {
	return prolooks_hsl_construct (PROLOOKS_TYPE_HSL);
}


double prolooks_hsl_get_hue (ProlooksHSL* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_hue;
	return result;
}


void prolooks_hsl_set_hue (ProlooksHSL* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_hue = value;
}


double prolooks_hsl_get_saturation (ProlooksHSL* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_saturation;
	return result;
}


void prolooks_hsl_set_saturation (ProlooksHSL* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_saturation = value;
}


double prolooks_hsl_get_lightness (ProlooksHSL* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_lightness;
	return result;
}


void prolooks_hsl_set_lightness (ProlooksHSL* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_lightness = value;
}


static void prolooks_value_hsl_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void prolooks_value_hsl_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		prolooks_hsl_unref (value->data[0].v_pointer);
	}
}


static void prolooks_value_hsl_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = prolooks_hsl_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer prolooks_value_hsl_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* prolooks_value_hsl_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	(void) n_collect_values;
	(void) collect_flags;
	if (collect_values[0].v_pointer) {
		ProlooksHSL* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = prolooks_hsl_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* prolooks_value_hsl_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ProlooksHSL** object_p;
	(void) n_collect_values;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME ((GValue*)value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = prolooks_hsl_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* prolooks_param_spec_hsl (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ProlooksParamSpecHSL* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PROLOOKS_TYPE_HSL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer prolooks_value_get_hsl (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE ((GValue*)value, PROLOOKS_TYPE_HSL), NULL);
	return value->data[0].v_pointer;
}


void prolooks_value_set_hsl (GValue* value, gpointer v_object) {
	ProlooksHSL* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PROLOOKS_TYPE_HSL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PROLOOKS_TYPE_HSL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		prolooks_hsl_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		prolooks_hsl_unref (old);
	}
}


void prolooks_value_take_hsl (GValue* value, gpointer v_object) {
	ProlooksHSL* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PROLOOKS_TYPE_HSL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PROLOOKS_TYPE_HSL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		prolooks_hsl_unref (old);
	}
}

static void prolooks_hsl_finalize (ProlooksHSL* obj) {
	ProlooksHSL * self;
	self = PROLOOKS_HSL (obj);
}

static void prolooks_hsl_class_init (ProlooksHSLClass * klass) {
	prolooks_hsl_parent_class = g_type_class_peek_parent (klass);
	PROLOOKS_HSL_CLASS (klass)->finalize = prolooks_hsl_finalize;
	g_type_class_add_private (klass, sizeof (ProlooksHSLPrivate));
}


static void prolooks_hsl_instance_init (ProlooksHSL * self) {
	self->priv = PROLOOKS_HSL_GET_PRIVATE (self);
	self->ref_count = 1;
}



GType prolooks_hsl_get_type (void) {
	static volatile gsize prolooks_hsl_type_id__volatile = 0;
	if (g_once_init_enter (&prolooks_hsl_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { prolooks_value_hsl_init, prolooks_value_hsl_free_value, prolooks_value_hsl_copy_value, prolooks_value_hsl_peek_pointer, "p", prolooks_value_hsl_collect_value, "p", prolooks_value_hsl_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ProlooksHSLClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prolooks_hsl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProlooksHSL), 0, (GInstanceInitFunc) prolooks_hsl_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType prolooks_hsl_type_id;
		prolooks_hsl_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ProlooksHSL", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&prolooks_hsl_type_id__volatile, prolooks_hsl_type_id);
	}
	return prolooks_hsl_type_id__volatile;
}


gpointer prolooks_hsl_ref (gpointer instance) {
	ProlooksHSL* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void prolooks_hsl_unref (gpointer instance) {
	ProlooksHSL* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PROLOOKS_HSL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


char* prolooks_hsv_to_string (ProlooksHSV* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup_printf ("HSV (%f, %f, %f)", self->priv->_hue, self->priv->_saturation, self->priv->_value);
	return result;
}


ProlooksHSV* prolooks_hsv_construct_for_gdk_color (GType object_type, const GdkColor* color) {
	ProlooksHSV* self;
	self = (ProlooksHSV*) g_type_create_instance (object_type);
	prolooks_hsv_from_gdk_color (self, color);
	return self;
}


ProlooksHSV* prolooks_hsv_new_for_gdk_color (const GdkColor* color) {
	return prolooks_hsv_construct_for_gdk_color (PROLOOKS_TYPE_HSV, color);
}


ProlooksHSV* prolooks_hsv_construct_for_cairo_color (GType object_type, CairoColor* color) {
	ProlooksHSV* self;
	g_return_val_if_fail (color != NULL, NULL);
	self = (ProlooksHSV*) g_type_create_instance (object_type);
	prolooks_hsv_from_cairo_color (self, color);
	return self;
}


ProlooksHSV* prolooks_hsv_new_for_cairo_color (CairoColor* color) {
	return prolooks_hsv_construct_for_cairo_color (PROLOOKS_TYPE_HSV, color);
}


CairoColor* prolooks_hsv_to_cairo_color (ProlooksHSV* self) {
	CairoColor* result = NULL;
	double r;
	double g;
	double b;
	gint hi = 0;
	double f = 0.0;
	double p = 0.0;
	double q = 0.0;
	double t = 0.0;
	CairoColor* color;
	g_return_val_if_fail (self != NULL, NULL);
	r = 0.0;
	g = 0.0;
	b = 0.0;
	hi = (gint) prolooks_modula (floor (self->priv->_hue / 60.0), (double) 6);
	f = (self->priv->_hue / 60.0) - floor (self->priv->_hue / 60.0);
	p = self->priv->_value * (1.0 - self->priv->_saturation);
	q = self->priv->_value * (1.0 - (f * self->priv->_saturation));
	t = self->priv->_value * (1.0 - ((1.0 - f) * self->priv->_saturation));
	switch (hi) {
		case 0:
		{
			r = self->priv->_value;
			g = t;
			b = p;
			break;
		}
		case 1:
		{
			r = q;
			g = self->priv->_value;
			b = p;
			break;
		}
		case 2:
		{
			r = p;
			g = self->priv->_value;
			b = t;
			break;
		}
		case 3:
		{
			r = p;
			g = q;
			b = self->priv->_value;
			break;
		}
		case 4:
		{
			r = t;
			g = p;
			b = self->priv->_value;
			break;
		}
		case 5:
		{
			r = self->priv->_value;
			g = p;
			b = q;
			break;
		}
		default:
		{
			break;
		}
	}
	color = cairo_color_new (r, g, b, 1.0);
	result = color;
	return result;
}


void prolooks_hsv_to_gdk_color (ProlooksHSV* self, GdkColor* result) {
	GdkColor _tmp1_ = {0,0,0,0};
	CairoColor* _tmp0_;
	GdkColor _tmp2_;
	g_return_if_fail (self != NULL);
	*result = (_tmp2_ = (prolooks_cairo_color_to_gdk (_tmp0_ = prolooks_hsv_to_cairo_color (self), &_tmp1_), _tmp1_), _cairo_color_unref0 (_tmp0_), _tmp2_);
	return;
}


void prolooks_hsv_from_gdk_color (ProlooksHSV* self, const GdkColor* color) {
	CairoColor* _tmp0_;
	g_return_if_fail (self != NULL);
	prolooks_hsv_from_cairo_color (self, _tmp0_ = prolooks_gdk_color_to_cairo (color));
	_cairo_color_unref0 (_tmp0_);
}


void prolooks_hsv_from_cairo_color (ProlooksHSV* self, CairoColor* color) {
	double min = 0.0;
	double max = 0.0;
	double delta = 0.0;
	double red;
	double green;
	double blue;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	red = cairo_color_get_red (color);
	green = cairo_color_get_green (color);
	blue = cairo_color_get_blue (color);
	if (red > green) {
		if (red > blue) {
			max = red;
		} else {
			max = blue;
		}
		if (green < blue) {
			min = green;
		} else {
			min = blue;
		}
	} else {
		if (green > blue) {
			max = green;
		} else {
			max = blue;
		}
		if (red < blue) {
			min = red;
		} else {
			min = blue;
		}
	}
	prolooks_hsv_set_value (self, max);
	if (fabs (max - min) < 0.0001) {
		prolooks_hsv_set_hue (self, 0.0);
		prolooks_hsv_set_saturation (self, 0.0);
	} else {
		if (max < 0.0001) {
			prolooks_hsv_set_saturation (self, (double) 0);
		} else {
			prolooks_hsv_set_saturation (self, (max - min) / max);
		}
		delta = max - min;
		if (red == max) {
			prolooks_hsv_set_hue (self, (green - blue) / delta);
		} else {
			if (green == max) {
				prolooks_hsv_set_hue (self, 2.0 + ((blue - red) / delta));
			} else {
				if (blue == max) {
					prolooks_hsv_set_hue (self, 4.0 + ((red - green) / delta));
				}
			}
		}
		prolooks_hsv_set_hue (self, self->priv->_hue * 60.0);
		if (self->priv->_hue < 0.0) {
			prolooks_hsv_set_hue (self, self->priv->_hue + 360.0);
		}
	}
}


ProlooksHSV* prolooks_hsv_construct (GType object_type) {
	ProlooksHSV* self;
	self = (ProlooksHSV*) g_type_create_instance (object_type);
	return self;
}


ProlooksHSV* prolooks_hsv_new (void) {
	return prolooks_hsv_construct (PROLOOKS_TYPE_HSV);
}


double prolooks_hsv_get_hue (ProlooksHSV* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_hue;
	return result;
}


void prolooks_hsv_set_hue (ProlooksHSV* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_hue = value;
}


double prolooks_hsv_get_saturation (ProlooksHSV* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_saturation;
	return result;
}


void prolooks_hsv_set_saturation (ProlooksHSV* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_saturation = value;
}


double prolooks_hsv_get_value (ProlooksHSV* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_value;
	return result;
}


void prolooks_hsv_set_value (ProlooksHSV* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = value;
}


static void prolooks_value_hsv_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void prolooks_value_hsv_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		prolooks_hsv_unref (value->data[0].v_pointer);
	}
}


static void prolooks_value_hsv_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = prolooks_hsv_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer prolooks_value_hsv_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* prolooks_value_hsv_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	(void) collect_flags;
	(void) n_collect_values;
	if (collect_values[0].v_pointer) {
		ProlooksHSV* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = prolooks_hsv_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* prolooks_value_hsv_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ProlooksHSV** object_p;
	(void) n_collect_values;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME ((GValue*)value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = prolooks_hsv_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* prolooks_param_spec_hsv (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ProlooksParamSpecHSV* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PROLOOKS_TYPE_HSV), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer prolooks_value_get_hsv (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE ((GValue*) value, PROLOOKS_TYPE_HSV), NULL);
	return value->data[0].v_pointer;
}


void prolooks_value_set_hsv (GValue* value, gpointer v_object) {
	ProlooksHSV* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PROLOOKS_TYPE_HSV));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PROLOOKS_TYPE_HSV));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		prolooks_hsv_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		prolooks_hsv_unref (old);
	}
}


void prolooks_value_take_hsv (GValue* value, gpointer v_object) {
	ProlooksHSV* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PROLOOKS_TYPE_HSV));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PROLOOKS_TYPE_HSV));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		prolooks_hsv_unref (old);
	}
}

static void prolooks_hsv_finalize (ProlooksHSV* obj) {
	ProlooksHSV * self;
	self = PROLOOKS_HSV (obj);
}

static void prolooks_hsv_class_init (ProlooksHSVClass * klass) {
	prolooks_hsv_parent_class = g_type_class_peek_parent (klass);
	PROLOOKS_HSV_CLASS (klass)->finalize = prolooks_hsv_finalize;
	g_type_class_add_private (klass, sizeof (ProlooksHSVPrivate));
}


static void prolooks_hsv_instance_init (ProlooksHSV * self) {
	self->priv = PROLOOKS_HSV_GET_PRIVATE (self);
	self->ref_count = 1;
}

GType prolooks_hsv_get_type (void) {
	static volatile gsize prolooks_hsv_type_id__volatile = 0;
	if (g_once_init_enter (&prolooks_hsv_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { prolooks_value_hsv_init, prolooks_value_hsv_free_value, prolooks_value_hsv_copy_value, prolooks_value_hsv_peek_pointer, "p", prolooks_value_hsv_collect_value, "p", prolooks_value_hsv_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ProlooksHSVClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prolooks_hsv_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProlooksHSV), 0, (GInstanceInitFunc) prolooks_hsv_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType prolooks_hsv_type_id;
		prolooks_hsv_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ProlooksHSV", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&prolooks_hsv_type_id__volatile, prolooks_hsv_type_id);
	}
	return prolooks_hsv_type_id__volatile;
}


gpointer prolooks_hsv_ref (gpointer instance) {
	ProlooksHSV* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void prolooks_hsv_unref (gpointer instance) {
	ProlooksHSV* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PROLOOKS_HSV_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


void prolooks_shade_color (const GdkColor* orig, double shade_ratio, GdkColor* result) {
	ProlooksHSL* HSL;
	GdkColor _tmp0_ = {0,0,0,0};
	GdkColor _result_;
	HSL = prolooks_hsl_new ();
	prolooks_hsl_from_gdk_color (HSL, orig);
	prolooks_hsl_set_lightness (HSL, fmin (prolooks_hsl_get_lightness (HSL) * shade_ratio, 1.0));
	prolooks_hsl_set_lightness (HSL, fmax (prolooks_hsl_get_lightness (HSL), 0.0));
	prolooks_hsl_set_saturation (HSL, fmin (prolooks_hsl_get_saturation (HSL) * shade_ratio, 1.0));
	prolooks_hsl_set_saturation (HSL, fmax (prolooks_hsl_get_saturation (HSL), 0.0));
	_result_ = (prolooks_hsl_to_gdk_color (HSL, &_tmp0_), _tmp0_);
	*result = _result_;
	_prolooks_hsl_unref0 (HSL);
	return;
}


GdkPixbuf* prolooks_cairo_image_surface_to_pixbuf (cairo_surface_t* surface) {
	GdkPixbuf* result = NULL;
	guchar* _tmp0_;
	guchar* knob_data;
	g_return_val_if_fail (surface != NULL, NULL);
	if (cairo_image_surface_get_format (surface) != CAIRO_FORMAT_ARGB32) {
		result = NULL;
		return result;
	}
	knob_data = (_tmp0_ = cairo_image_surface_get_data (surface), _tmp0_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				guchar r;
				guchar g;
				guchar b;
				guchar a;
				if (!_tmp1_) {
					i = i + 4;
				}
				_tmp1_ = FALSE;
				if (!(i < (cairo_image_surface_get_height (surface) * cairo_image_surface_get_stride (surface)))) {
					break;
				}
				r = knob_data[i + 0];
				g = knob_data[i + 1];
				b = knob_data[i + 2];
				a = knob_data[i + 3];
				knob_data[i + 0] = b;
				knob_data[i + 1] = g;
				knob_data[i + 2] = r;
				knob_data[i + 3] = a;
			}
		}
	}
	result = gdk_pixbuf_new_from_data (knob_data, GDK_COLORSPACE_RGB, TRUE, 8, cairo_image_surface_get_width (surface), cairo_image_surface_get_height (surface), cairo_image_surface_get_stride (surface), NULL, NULL);
	return result;
}




