
#ifndef DEV_H

/*
 * Abstract base class for all devices handled here.
 */

/* 
 * Argyll Color Correction System
 *
 * Author: Graeme W. Gill
 * Date:   17/8/2016
 *
 * Copyright 2016 Graeme W. Gill
 * All rights reserved.
 *
 * This material is licenced under the GNU GENERAL PUBLIC LICENSE Version 2 or later :-
 * see the License2.txt file for licencing details.
 *
 */

#include "icoms.h"			/* libinst Includes this functionality */
#include "conv.h"

#ifdef __cplusplus
	extern "C" {
#endif

/* Device base object. */
#define DEV_OBJ_BASE															\
	a1log *log;			/* Pointer to debug & error logging class */			\
	icoms *icom;		/* Device coms object */								\
	instType  itype;	/* Device type determined by driver */					\

/* The base object type */
struct _dev {
	DEV_OBJ_BASE
	}; typedef struct _dev dev;

#define DEV_H
#endif /* DEV_H */
