/* $Id: ArkLoaderSeq.cpp,v 1.3 2002/10/28 22:31:16 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) David Farrell <fdavid@cyberramp.net>
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>

#include <Ark/Ark.h>
#include <Ark/ArkCache.h>
#include <Ark/ArkSequence.h>
#include <Ark/ArkLoader.h>
#include <Ark/ArkLexer.h>
#include <Ark/ArkString.h>


namespace Ark
{

   class LoaderSeq : public Loader
   {
	 /// Returns true if the file pointed to by \c name does really
	 /// contains an HalfLife MDL, and if this loader can load it.
	 virtual bool CanLoad (ObjectType type, Stream &stream,
			       const String &name, const String &args)
	 {
	    if (type != V_SEQUENCE)
	       return false;
	    
	    Lexer lex (name, stream);
	    return lex.GetToken () == "ArkSequence";
	 }

	 /// Returns informations about the formats supported by this loader.
	 virtual String GetInformations()
	 {
	    return "Ark Sequence";
	 }
	 /// Load the file pointed to by \c name, and read a object in it.
	 /// It will update the progress every \c granularity percents.
	 virtual bool Load (Object *vis, Stream &file, const String &name,
			    const String &args, Cache *cache,
			    Progress *progress, int granularity)
	 {
	    //cout << "Loading sequence " << name << "\n";
	    if (vis == NULL || vis->Type() != V_SEQUENCE)
	       return false;

	    Sequence *seq = static_cast<Sequence*>(vis);
	    return seq->Read(name, file);
	 }
	 
   };
   
   extern void ark_AddSeqLoader (Loaders *loaders)
   {
      loaders->Add (new LoaderSeq);
   }

} // namespace Ark


