/* $Id: RemoteUpdater.h,v 1.5 2002/08/29 08:07:25 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CLIENT_REMOTEUPDATER_H
#define CLIENT_REMOTEUPDATER_H

#include <Ark/ArkWorldUpd.h>
#include <Ark/ArkSocket.h>
#include <Ark/ArkCollision.h>

namespace Client
{
   class RemoteUpdater : public Ark::WorldUpdater
   {
      public:
	 /// Create a remote updater.
	 RemoteUpdater(Ark::Cache *cache);

	 /** Destroy the world updater. */
	 virtual ~RemoteUpdater();

	 /** Load the world whose path is \c name.
	  */
	 virtual void LoadWorld (const Ark::String &name);

	 /**
	  * Return the previously loaded world, or nil if no world has
	  * been loaded.
	  */
	 virtual Ark::World *GetWorld();

	 /** Try to login an entity. This means that the world part in
	  * which this entity lay is loaded, then all entity states are
	  * loaded ; finally the entity is returned. 
	  */
	 virtual Ark::Entity *Login (const Ark::String &login,
				     const Ark::String &password = "");
	 
	 /// Make the world in sync with the remote systems.
	 virtual bool Update (scalar delta_time);


      protected:
	 virtual void HintEntityRemoved (int entityID){}
	 virtual void HintEntityAdded (int entityID){}

	 bool HandleUpdates();
	 bool HandleEntities(Ark::ReadStream *pak);
	 bool HandleConnection(Ark::ReadStream *pak);
	 bool HandleMessages(Ark::ReadStream *pak);

	 Ark::World *m_World;
	 Ark::Cache *m_Cache;
	 Ark::Socket *m_Socket;
	 int m_ClientEntityID;
   };

   Ark::WorldUpdater *CreateUpdater (const Ark::String &name,
				     Ark::Cache *cache);
}

#endif
