/* $Id: LuaWorld.h,v 1.8 2003/03/15 17:49:04 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef LUA_WORLD_H
#define LUA_WORLD_H

#include <Modules/Lua/ArkLua.h>

#include <Engine/Engine.h>
#include <Modules/Lua/luna.h>
#include <Ark/ArkLight.h>

namespace Ark
{

   class ARKLUA_DLL_API LuaWorld : public LunaObject
   {
      public:
	 static const char className[];
	 static const Luna<LuaWorld>::RegType Register[];
    
      private:
	 Ark::World *m_World;
    
      public:
	 LuaWorld(lua_State *L);
	 ~LuaWorld();
    
	 int insert (lua_State *L);
	 int remove (lua_State *L);

	 /**
	  * Get all the entities of the world
	  */
	 int get_all_entities(lua_State* L);
    
	 /**
	  * Find an entity given its id.
	  */
	 int get_entity(lua_State* L);
    
	 /**
	  * Find an entity given its shortname
	  */
	 int get_entity_by_name (lua_State *L);

	 /**
	  * Find all entities given their class
	  */
	 int find_entities_by_class(lua_State* L);

	 /**
	  * Test if collision occurs between a bounding box and entities
	  */
	 int test_collision_with_entities(lua_State* L);

	 /** 
	  * This is the function to ask for anything about the world. It
	  * should at term replace all above functions. The syntax will be
	  * developped here later.
	  * TODO: Define the syntax for the requests
	  */
	 int request (lua_State *L);

	 // Athmosphere related functions..
	 int set_time_of_day (lua_State *L);
	 int set_fog_density (lua_State *L);
	 int set_fog_color (lua_State *L);

	 int get_time_of_day (lua_State *L);
	 int get_fog_density (lua_State *L);
	 int get_fog_color (lua_State *L);

	 int set_light_color (lua_State *L);
	 int set_light_position (lua_State *L);
	 int set_light_type (lua_State *L);
	 int set_light_attenuation (lua_State *L);

	 int get_light_color (lua_State *L);
	 int get_light_position (lua_State *L);
	 int get_light_type (lua_State *L);
	 int get_light_attenuation (lua_State *L);
    
      private:
	 Light &get_light (lua_State *L, int posinstack);
  };
}


#endif
