# - Find ATLAS version of CLAPACK (includes and library)
# This module defines
#  CLAPACKATLAS_INCLUDE_DIR
#  CLAPACKATLAS_LIBRARIES
#  CLAPACKATLAS_FOUND
# also defined, but not for general use are
#  CLAPACKATLAS_LIBRARY, where to find the library.

FIND_PATH(CLAPACKATLAS_INCLUDE_DIR clapack.h
/usr/include/atlas
/usr/local/include/atlas
/usr/include
/usr/local/include
)

SET(CLAPACKATLAS_NAMES ${CLAPACKATLAS_NAMES} lapack_atlas)
FIND_LIBRARY(CLAPACKATLAS_LIBRARY
  NAMES ${CLAPACKATLAS_NAMES}
  PATHS /usr/lib64/atlas /usr/lib/atlas /usr/local/lib64/atlas /usr/local/lib/atlas /usr/lib64 /usr/lib /usr/local/lib64 /usr/local/lib
  )

IF (CLAPACKATLAS_LIBRARY AND CLAPACKATLAS_INCLUDE_DIR)
    SET(CLAPACKATLAS_LIBRARIES ${CLAPACKATLAS_LIBRARY})
    SET(CLAPACKATLAS_FOUND "YES")
ELSE (CLAPACKATLAS_LIBRARY AND CLAPACKATLAS_INCLUDE_DIR)
  SET(CLAPACKATLAS_FOUND "NO")
ENDIF (CLAPACKATLAS_LIBRARY AND CLAPACKATLAS_INCLUDE_DIR)


IF (CLAPACKATLAS_FOUND)
   IF (NOT CLAPACKATLAS_FIND_QUIETLY)
      MESSAGE(STATUS "Found ATLAS specific CLAPACK library: ${CLAPACKATLAS_LIBRARIES}")
   ENDIF (NOT CLAPACKATLAS_FIND_QUIETLY)
ELSE (CLAPACKATLAS_FOUND)
   IF (CLAPACKATLAS_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "Could not find the ATLAS specific CLAPACK library")
   ENDIF (CLAPACKATLAS_FIND_REQUIRED)
ENDIF (CLAPACKATLAS_FOUND)

# Deprecated declarations.
SET (NATIVE_CLAPACKATLAS_INCLUDE_PATH ${CLAPACKATLAS_INCLUDE_DIR} )
GET_FILENAME_COMPONENT (NATIVE_CLAPACKATLAS_LIB_PATH ${CLAPACKATLAS_LIBRARY} PATH)

MARK_AS_ADVANCED(
  CLAPACKATLAS_LIBRARY
  CLAPACKATLAS_INCLUDE_DIR
  )
