//error.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2011
 *
 *  This file is part of aroarfw, a RoarAudio framework for
 *  embedded systems (Controlers).
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  aroarfw is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef _AROARFW_ERROR_H_
#define _AROARFW_ERROR_H_

//$ grep '^#define ROAR_ERROR_' error.h  | sed 's/^#define ROAR_ERROR_//; s/   */ /g; s/ \/\* / /; s/ \*\/$//' | while read name id msg; do printf " //! %s\n RERROR_%-11s = %2i,\n" "$msg" $name $id; done

//! Error codes for on-wire protocol
typedef enum {
 //! Unknown (maybe no) error
 RERROR_UNKNOWN     = -1,
 //! No error. Can be used to initialize error variables.
 RERROR_NONE        =  0,
 //! Operation not permitted
 RERROR_PERM        =  1,
 //! No such file or directory
 RERROR_NOENT       =  2,
 //! Bad message
 RERROR_BADMSG      =  3,
 //! Device or resource busy
 RERROR_BUSY        =  4,
 //! Connection refused
 RERROR_CONNREFUSED =  5,
 //! Function not implemented
 RERROR_NOSYS       =  6,
 //! Operation not supported
 RERROR_NOTSUP      =  7,
 //! Broken pipe
 RERROR_PIPE        =  8,
 //! Protocol error
 RERROR_PROTO       =  9,
 //! Result too large/general out of range
 RERROR_RANGE       = 10,
 //! Message too long
 RERROR_MSGSIZE     = 11,
 //! Not enough space
 RERROR_NOMEM       = 12,
 //! Invalid argument
 RERROR_INVAL       = 13,
 //! Connection already in progress
 RERROR_ALREADY     = 14,
 //! Invalid request code
 RERROR_BADRQC      = 15,
 //! Mathematics argument out of domain of function
 RERROR_DOM         = 16,
 //! File or object exists
 RERROR_EXIST       = 17,
 //! Bad address
 RERROR_FAULT       = 18,
 //! I/O-Error
 RERROR_IO          = 19,
 //! Key has expired
 RERROR_KEYEXPIRED  = 20,
 //! Key was rejected by service
 RERROR_KEYREJECTED = 21,
 //! Too many recursions
 RERROR_LOOP        = 22,
 //! Too many open files or objects
 RERROR_MFILE       = 23,
 //! File or object name too long
 RERROR_NAMETOOLONG = 24,
 //! No message is available on the read queue
 RERROR_NODATA      = 25,
 //! No such device
 RERROR_NODEV       = 26,
 //! No such driver
 RERROR_NODRV       = 27,
 //! No space left on device
 RERROR_NOSPC       = 38,
 //! Type missmatch. Object of diffrent type required
 RERROR_TYPEMM      = 39,
 //! Feature not implemented by remote end
 RERROR_NORSYS      = 40,
 //! Socket or object not connected
 RERROR_NOTCONN     = 41,
 //! Protocol not supported
 RERROR_PROTONOSUP  = 42,
 //! Remote I/O Error
 RERROR_RIO         = 43,
 //! File or object is read only
 RERROR_RO          = 45,
 //! Connection timed out
 RERROR_TIMEDOUT    = 46,
 //! Resource temporarily unavailable
 RERROR_AGAIN       = 47,
 //! Line too noisy
 RERROR_NOISE       = 48,
 //! Physical or logical link down
 RERROR_LINKDOWN    = 49,
 //! Operation was interruped
 RERROR_INTERRUPTED = 50,
 //! Causality error
 RERROR_CAUSALITY   = 51,
 //! Quota exceeded
 RERROR_QUOTA       = 52,
 //! Accessing a corrupted shared library
 RERROR_BADLIB      = 53,
 //! No medium found
 RERROR_NOMEDIUM    = 54,
 //! Name not unique
 RERROR_NOTUNIQ     = 55,
 //! Illegal byte sequence
 RERROR_ILLSEQ      = 56,
 //! Address in use
 RERROR_ADDRINUSE   = 57,
 //! Hole in data
 RERROR_HOLE        = 58,
 //! Bad version
 RERROR_BADVERSION  = 59,
 //! Not supported version
 RERROR_NSVERSION   = 60,
 //! Bad magic number
 RERROR_BADMAGIC    = 61,
 //! Lost synchronization
 RERROR_LOSTSYNC    = 62,
 //! Can not seek to destination position
 RERROR_BADSEEK     = 63,
 //! Seeking not supported on resource
 RERROR_NOSEEK      = 64,
 //! Data integrity error
 RERROR_BADCKSUM    = 65,
 //! Mount failed
 RERROR_NOHORSE     = 66,
 //! Fatal device error
 RERROR_CHERNOBYL   = 67,
 //! Device needs love
 RERROR_NOHUG       = 68,
 //! Text file busy
 RERROR_TEXTBUSY    = 69,
 //! Directory not empty
 RERROR_NOTEMPTY    = 70,
 //! Node is unreachable
 RERROR_NODEUNREACH = 71,
 //! Identifier removed
 RERROR_IDREMOVED   = 72,
 //! Operation in progress
 RERROR_INPROGRESS  = 73,
 //! No child processes/object
 RERROR_NOCHILD     = 74,
 //! Network unreachable
 RERROR_NETUNREACH  = 75,
 //! Operation canceled
 RERROR_CANCELED    = 76,
 //! Is a directory
 RERROR_ISDIR       = 77,
 //! Not a directory
 RERROR_NOTDIR      = 78,
 //! Executable file format error
 RERROR_BADEXEC     = 79,
 //! Socket/Object is connected
 RERROR_ISCONN      = 80,
 //! Resource deadlock would occur
 RERROR_DEADLOCK    = 81,
 //! Connection reset
 RERROR_CONNRST     = 82,
 //! Bad file handle
 RERROR_BADFH       = 83,
 //! Not a socket
 RERROR_NOTSOCK     = 84,
 //! Argument list too long
 RERROR_TOOMANYARGS = 85,
 //! File/Object too large
 RERROR_TOOLARGE    = 86,
 //! Destination address required
 RERROR_DESTADDRREQ = 87,
 //! Address family not supported
 RERROR_AFNOTSUP    = 88,
 //! Operation can not be completed because we are low on power
 RERROR_NOPOWER     = 89,
 //! Error in front of screen
 RERROR_USER        = 90,
 //! Too many files/objects open in system
 RERROR_NFILE       = 91,
 //! Stale file handle or object
 RERROR_STALE       = 92,
 //! Cross-device link
 RERROR_XDEVLINK    = 93,
 //! Too many links to file or object
 RERROR_MLINK       = 94,
 //! Not connected to any network
 RERROR_NONET       = 95,
 //! Connection reset by network
 RERROR_CONNRSTNET  = 96,
 //! Connection aborted
 RERROR_CONNABORTED = 97
} rerror_t;

#endif

//ll
