/*******************************************************
 * Copyright (c) 2014, ArrayFire
 * All rights reserved.
 *
 * This file is distributed under 3-clause BSD license.
 * The complete license agreement can be obtained at:
 * http://arrayfire.com/licenses/BSD-3-Clause
 ********************************************************/
#pragma once

#include <platform.hpp>
#include <af/defines.h>

namespace opencl
{

    cl::Buffer *bufferAlloc(const size_t &bytes);
    void bufferFree(cl::Buffer *buf);
    void bufferUnlink(cl::Buffer *ptr);

    template<typename T> T *memAlloc(const size_t &elements);
    template<typename T> void memFree(T *ptr);
    template<typename T> void memUnlink(T *ptr);

    template<typename T> T* pinnedAlloc(const size_t &elements);
    template<typename T> void pinnedFree(T* ptr);

    static const unsigned MAX_BUFFERS   = 100;
    static const unsigned MAX_BYTES     = (1 << 30);

    void deviceMemoryInfo(size_t *alloc_bytes, size_t *alloc_buffers,
                          size_t *lock_bytes,  size_t *lock_buffers);
    void garbageCollect();
    void pinnedGarbageCollect();

    void setMemStepSize(size_t step_bytes);
    size_t getMemStepSize(void);
}
