##
# Misc functions
##


def action_report(msg, action):
    ''' Executes action and prints the success state.
    '''
    print '%s: ' % (msg,),
    if action():
        print 'done.'
        return True
    else:
        print 'fail.'
        return False


def check_report(msg, action):
    if not action():
        print >>sys.stderr, '%s' % (msg,)
        return False
    return True


def git_checkout(repo, branch):
    ''' Switch repo to branch.
    '''
    try:
        repo.git.checkout(branch)
    except git.exc.GitCommandError:
        return False
    return True


def list_module(self, name, order='build'):
    module = self.get_module(name)
    if order not in set(('raw', 'alpha', 'build')):
        raise ValueError('Invalid value for order')

    s = lambda ps: ps
    if order == 'alpha':
        s = sorted
    elif order == 'build':
        s = lambda packages: self.sort_buildable(packages)

    for package in s(module.packages):
        print package
