/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __MP3DOC_H__
#define __MP3DOC_H__

/*========================================================*/
/*	This file, mp3doc.cpp, and mp3writer.* are misnamed,
 *	they implement audio writing as a whole, and not just
 *	mp3 writing... they will be renamed at some point...
 *========================================================*/

#include "arson.h"

#include <qstringlist.h>

#include "docwidget.h"
#include "audiofile.h"

/*========================================================*/

class ArsonMp3ListItem : public ArsonFileListFileItem
{
public:
	ArsonMp3ListItem (const KURL &url);

	virtual uint length (void) const { return m_length; }
	virtual void refresh (QListViewItem *pi, ArsonDocWidget *pd);

	QString displayTime (void) const;

	const QString &title (void) const { return m_title; }

private:
	QString m_title;
	int m_length;
};

/*========================================================*/

class ArsonTocFile;

class ArsonMp3Doc : public ArsonFileListDoc
{
public:
	ArsonMp3Doc (QWidget *parent, const char *name = NULL);

	virtual ArsonProcessMgr *createCdWriter (ArsonProcessUI *pUI);
	virtual void delItem (QListViewItem *pi);

	virtual QString propDocType (void) const;
	
private:
	virtual ArsonFileListItem *createFileItem (const KURL &url) const;
	virtual void buildFileFilter (ArsonFileFilter &filter);
	virtual ArsonProgressDlg *createProgressDlg (void);
	virtual ArsonListWnd *createListWnd (void);
	virtual QString progressString (int length) const;
	virtual int getMaxProgress (void) const;
};

/*========================================================*/

class ArsonTocFile
{
public:
	ArsonTocFile (void);
	~ArsonTocFile (void);

	const QString &errorString (void) const { return m_strError; }
	const QString &filename (void) const { return m_filename; }
	int size (void) const { return m_files.count(); }
	const QString &decodedFile (int index) const
	{ return m_files[index]; }

	bool writeFile (const char *filename = NULL);
	bool addFile (const QString &fname);

private:
	QString m_filename;
	QString m_strError;
	QStringList m_files;
	bool m_bTemp;
};

/*========================================================*/
#endif	/*	__MP3DOC_H__	*/
