/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __ISOFS_H__
#define __ISOFS_H__

#include <qmap.h>

#include "progressdlg.h"
#include "cdwriter.h"
#include "process.h"

#include "_isofs.h"

/*========================================================*/

class ArsonProcessBase;
class QXmlAttributes;
class ArsonXmlWriter;

class ArsonIsoFlags
{
	typedef QMap<QString,QString> FLAGMAP;

public:
	ArsonIsoFlags (void);

	void clear (void) { m_map.clear(); }
	ArsonIsoFlags &addFlag (const char *sw, const QString &val = QString::null) {
		m_map.insert(sw, val);
		return *this;
	}
	bool hasFlag (const char *sw) const { return m_map.contains(sw); }
	QString value (const QString &key) const {
		return hasFlag(key) ? m_map[key] : QString::null;
	}

	void load (const QString &name, const QXmlAttributes &attr);
	void save (ArsonXmlWriter &writer);

	void applyTo (ArsonProcessBase *proc, const QString &fn) const;
	
private:
	FLAGMAP m_map;
};

/*========================================================*/

class ArsonIsoPresets
{
	typedef QMap<QString,ArsonIsoFlags> PRESETMAP;

public:
	ArsonIsoPresets (void);

	void addPreset (const QString &name, ArsonIsoFlags &flags);
	void remove (const QString &name);
	void save (void);
	
	QStringList names (void) const;

	uint count (void) const { return m_map.count(); }
	ArsonIsoFlags *flags (const QString &name) {
		return (m_map.contains(name))
			? &m_map[name] : NULL;
	}

	static const QString &defaultName (void);

protected:
	PRESETMAP m_map;
};

/*========================================================*/

class ArsonIsoSizeProcess : public ArsonUtilityProcess
{
public:
	ArsonIsoSizeProcess (const QString &fifo,
		const ArsonIsoFlags *pFlags, const QStringList &what);

	uint size (void) const { return m_size; }

protected:
	virtual void output (const QString &out, bool error);

	uint m_size;
};

/*========================================================*/

class ArsonMkisoProcess;
class ArsonFifo;

class ArsonIsoMgr : public ArsonIsoWriter
{
public:
	ArsonIsoMgr (ArsonProcessUI *pUI,
		const QStringList &what);
	virtual ~ArsonIsoMgr (void);

	virtual void begin (const ArsonProcessOpts &opts);
	virtual void taskComplete (ArsonProcess *ptr);

	void setIsoFlags (const ArsonIsoFlags &flags)
	{ m_isoFlags = flags; }
	
protected:
	virtual ArsonWriterProcess *createWriterProcess (void);
	virtual ArsonMkisoProcess *mkisofsProcess(
		const ArsonIsoFlags *pFlags,
		const QString &outfile,
		const QStringList &what);
	virtual ArsonIsoSizeProcess *sizeProcess(
		const ArsonIsoFlags *pFlags,
		const QString &outfile,
		const QStringList &what);

	void setupFifo (void);

	const QStringList &m_what;
	ArsonIsoFlags m_isoFlags;
	ArsonFifo *m_pFifo;
	uint m_size;
};

/*========================================================*/

class ArsonIsoProgressDlg : public ArsonImgCreateProgressDlg
{
	Q_OBJECT

public:
	ArsonIsoProgressDlg (QWidget *parent, const char *name);

private:
	virtual void processOpts (ArsonProcessOpts &opts);
	virtual void reconfigure (void);

	virtual ArsonProcessMgr *createProcessMgr (void);
	virtual ArsonIsoMgr *createIsoMgr (void) = 0;
	
	ArsonIsoFlags currentPreset (ArsonIsoPresets *ptr = NULL) const;
	QString currentPresetName (void) const;
	void fillPresets (void);

	QLineEdit *m_pIsoFile;
	QCheckBox *m_pDirect;
	QCheckBox *m_pDelete;
	QComboBox *m_pPresets;

protected slots:
	void iso_browse_clicked (void);
};

/*========================================================*/

class ArsonIsoWriterProgressDlg : public ArsonIsoProgressDlg
{
public:
	ArsonIsoWriterProgressDlg (QWidget *parent, const QStringList &dirs);

private:
	virtual ArsonIsoMgr *createIsoMgr (void);

	const QStringList &m_dirs;
};

/*========================================================*/
#endif	/*	__ISOFS_H__	*/
