/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*================================================*/
/*	The log window.
 *
 *	by Tony Sideris	(05:36PM Jan 26, 2002)
 *================================================*/
#include "arson.h"

#include <qlistbox.h>
#include <qvbox.h>
#include <qpushbutton.h>

#include <klocale.h>
#include <kaction.h>

#include "logwnd.h"
#include "mainwnd.h"

/*========================================================*/

ArsonLogWindow *ArsonLogWindow::theWindow = NULL;

/*========================================================*/

ArsonLogWindow::ArsonLogWindow (void)
	: KMainWindow()
{
	struct button {
		QString text;
		const char *slot;
	}	buttons[] = {
		/*
		 *	The row of buttons along the bottom
		 */
		{ i18n("&Clear"), SLOT(slotClear()) },
		{ i18n("&Save to File"), SLOT(slotSave()) },
	};
	
	Assert(theWindow == NULL);
	theWindow = this;

	QVBox *pv = new QVBox(this);
	QHBox *ph;

	m_pLB = new QListBox(pv);
	ph = new QHBox(pv);

	//	Create the row of buttons
	for (int index = 0; index < ARRSIZE(buttons); ++index)
	{
		QPushButton *ptr = new QPushButton(buttons[index].text, ph);
		QObject::connect(ptr, SIGNAL(clicked()),
			this, buttons[index].slot);
	}

	setCentralWidget(pv);

	m_pLB->setSelectionMode(QListBox::NoSelection);

	//	Set the window caption and resize
	setCaption(
		i18n("Command Log Window"));
	resize(int(width()/* * 1.5 */),
		int(height() * 0.33));
}

/*========================================================*/

ArsonLogWindow::~ArsonLogWindow (void)
{
	for (int index = 0; index < m_uiItems.count(); ++index)
		delete m_uiItems[index];

	Trace("Log window destroyed\n");
	theWindow = NULL;
}

/*========================================================*/

ArsonLogWindow *ArsonLogWindow::Wnd (void)
{
	if (!theWindow) new ArsonLogWindow;
	Assert(theWindow != NULL);
	return theWindow;
}

void ArsonLogWindow::finalize (void)
{
	delete theWindow;
	Assert(theWindow == NULL);
}

/*========================================================*/

void ArsonLogWindow::addUiItem (ArsonLogState *pUI)
{
	m_uiItems.append(pUI);

	pUI->setState(
		isVisible());
}

void ArsonLogWindow::delUiItem (ArsonLogState *pUI)
{
	UILIST::Iterator it = m_uiItems.find(pUI);

	m_uiItems.remove(it);
}

/*========================================================*/

void ArsonLogWindow::enableUI (bool enable)
{
	for (UILIST::Iterator it = m_uiItems.begin(), end = m_uiItems.end(); it != end; ++it)
		(*it)->setState(enable);
}

/*========================================================*/

void ArsonLogWindow::show (void)
{
	KMainWindow::show();
	enableUI(true);
}

void ArsonLogWindow::hide (void)
{
	KMainWindow::hide();
	enableUI(false);
}

/*========================================================*/

#define ARSON_LOG_MAX		512

void ArsonLogWindow::log (const QString &text)
{
	const int index = m_pLB->count();

	m_pLB->insertItem((text.length() > ARSON_LOG_MAX + 4)
		? (text.left(ARSON_LOG_MAX) + i18n("..."))
		: text);

	m_pLB->setSelected(index, true);
	m_pLB->setCurrentItem(index);
	m_pLB->setBottomItem(index);
}

/*========================================================*/

void ArsonLogWindow::closeEvent (QCloseEvent *pe)
{
	pe->ignore();
	hide();
}

/*========================================================*/

void ArsonLogWindow::slotClear (void)
{
	m_pLB->clear();
}

void ArsonLogWindow::slotSave (void)
{
	arsonSaveLogWindow(m_pLB);
}

/*========================================================*/
