/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __LOGWND_H__
#define __LOGWND_H__

#include <kmainwindow.h>
#include <kaction.h>

/*========================================================*/

class ArsonLogState
{
public:
	virtual void setState (bool visible) = 0;
};

class ArsonLogActionState : public ArsonLogState
{
public:
	ArsonLogActionState (KToggleAction *pa) : m_pa(pa) { }

	virtual void setState (bool visible) {
		m_pa->setChecked(visible);
	}

protected:
	KToggleAction *m_pa;
};

/*========================================================*/

class QListBox;

class ArsonLogWindow : public KMainWindow
{
	Q_OBJECT

	typedef QValueList<ArsonLogState*> UILIST;
	
public:
	static ArsonLogWindow *Wnd (void);
	static void finalize (void);

	void addUiItem (ArsonLogState *pUI);
	void delUiItem (ArsonLogState *pUI);
	
	void log (const QString &text);

	virtual void hide (void);
	virtual void show (void);
	
private:
	ArsonLogWindow (void);
	ArsonLogWindow (const ArsonLogWindow &cpy) { }
	virtual ~ArsonLogWindow (void);
	
	virtual void closeEvent (QCloseEvent *pe);

	void enableUI (bool enable);
	
	static ArsonLogWindow *theWindow;

	UILIST m_uiItems;
	QListBox *m_pLB;

	class you_bug_dummy;
	friend class you_bug_dummy;		//	Shuts up the compiler...

protected slots:
	void slotClear (void);
	void slotSave (void);
};

/*========================================================*/
#endif	/*	__LOGWND_H__	*/
