/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*================================================*/
/*	A simple dialog to display while performing a
 *	lengthy operation of unknown length.
 *
 *	by Tony Sideris	(06:52PM Sep 18, 2001)
 *================================================*/
#include <klocale.h>

#include <qpushbutton.h>
#include <qlabel.h>

#include "progressbar.h"
#include "waitdlg.h"

/*========================================================*/

ArsonWaitDlg::ArsonWaitDlg (QWidget *parent, bool modal)
	: ArsonWaitDlgBase(parent, NULL, modal)
{
	progress->setMode(arsonProgressInfinite);
}

ArsonWaitDlg::~ArsonWaitDlg (void)
{
	//	Nothing...
}

/*========================================================*/

void ArsonWaitDlg::setMessage (const QString &str)
{
	msg->setText(str);
}

/*========================================================*/

void ArsonWaitDlg::done (void)
{
	progress->setMode(arsonProgressBlank);
	progress->hide();

	cancel->setText(i18n("&Close"));
	setMessage(
		i18n("Complete."));
}

/*========================================================*/

void ArsonWaitDlg::dismiss (bool success)
{
	if (success)
		accept();
	else
		reject();
}

/*========================================================*/
