/***************************************************************************
                          replay.h  -  description
                             -------------------
    begin                : Sun Jan 21 2001
    copyright            : (C) 2001 by Martin Bickel
    email                : bickel@asc-hq.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef replayH
 #define replayH

#include "events.h"
#include "ascstring.h"
#include "gamemap.h"
#include "basestreaminterface.h"

/*! \file replay.h
    \brief Interface for recording and playing replays
*/


enum trpl_actions { rpl_attack,
                    rpl_move, 
                    rpl_changeheight, 
                    rpl_convert, 
                    rpl_remobj, 
                    rpl_buildobj, 
                    rpl_putbuilding,
                    rpl_removebuilding, 
                    rpl_putmine, 
                    rpl_removemine,
                    rpl_produceunit, 
                    rpl_removeunit,
                    rpl_trainunit,
                    rpl_reactionfire, 
                    rpl_finished, 
                    rpl_shareviewchange, 
                    rpl_alliancechange,
                    rpl_move2, 
                    rpl_buildtnk,
                    rpl_refuel, 
                    rpl_bldrefuel, 
                    rpl_move3, 
                    rpl_changeheight2,
                    rpl_buildtnk2,
                    rpl_moveUnitUpDown,
                    rpl_move4,
                    rpl_productionResourceUsage,
                    rpl_buildtnk3,
                    rpl_refuel2,
                    rpl_buildobj2,
                    rpl_remobj2,
                    rpl_repairUnit,
                    rpl_repairUnit2,
                    rpl_refuel3,
                    rpl_produceAmmo,
                    rpl_buildtnk4,
                    rpl_buildProdLine,
                    rpl_removeProdLine,
                    rpl_setResearch,
                    rpl_techResearched,
                    rpl_putbuilding2,
                    rpl_setGeneratorStatus,
                    rpl_cutFromGame,
                    rpl_removebuilding2,
                    rpl_setResourceProcessingAmount,
                    rpl_removebuilding3,
                    rpl_netcontrol,
                    rpl_move5,
                    rpl_alliancechange2,
                    rpl_moveUnitUp,
                    rpl_jump,
                    rpl_repairBuilding,
                    rpl_recycleUnit,
                    rpl_convert2,
                    rpl_putmine2,
                    rpl_repairUnit3,
                    rpl_transferTribute,
                    rpl_reactionFireOn,
                    rpl_reactionFireOff };

extern void logtoreplayinfo ( trpl_actions action, ... );

struct treactionfire_replayinfo;

class trunreplay {
            ASCString lastErrorMessage;
         protected:
            int movenum;
            void execnextreplaymove ( void );
            GameMap* orgmap;
            pmemorystream stream;
            void wait ( int t = ticker );
            void wait ( MapCoordinate pos, int t = ticker );
            void wait ( MapCoordinate pos1, MapCoordinate pos2, int t = ticker );
            int actplayer;

            void error( const char* message, ... );
            void error( const MapCoordinate& pos, const char* message, ... );
            void error( const ASCString& message );
            void error( const MapCoordinate& pos, const ASCString& message );

            char nextaction;

            void readnextaction ( void );
            void displayActionCursor ( int x1, int y1, int x2 = -1, int y2 = -1, int secondWait = 0 );
            void removeActionCursor( void );

         public:

            treactionfire_replayinfo* getnextreplayinfo ( void );

            trunreplay ( void );
            int status;
            void firstinit ( void );
            int  run ( int player, int viewingplayer, bool performEndTurnOperations );
   };

class LockReplayRecording {
        GameMap::ReplayInfo& ri;
     public:
        LockReplayRecording ( GameMap::ReplayInfo& _ri );
        ~LockReplayRecording();
};

extern trunreplay runreplay;

//! a hack to enable the replay in a game that was started without replays
extern int startreplaylate;

//! checks if there is replay information and -if there is any- runs the replay
extern void checkforreplay ( void );

//! Initialized the replay logging at the beginning of a players or the ai's turn.
extern void initReplayLogging( Player& player );

//! runs the replay for the given player
extern void runSpecificReplay( int player, int viewingplayer, bool performEndTurnOperations = true );

//! runs the replay of the current player. This is used primarily for debugging the replay system
extern void viewOwnReplay( Player& player );

//! initialized the replay system at program startup
extern void hookReplayToSystem();

#endif
