/*
     This file is part of Advanced Strategic Command; http://www.asc-hq.de
     Copyright (C) 1994-2008  Martin Bickel  and  Marc Schellenberger
 
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
 
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with this program; see the file COPYING. If not, write to the 
     Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
     Boston, MA  02111-1307  USA
*/


#ifndef CancelResearchCommandH
#define CancelResearchCommandH

#include "command.h"

class Player;

//! cancels the research on the current technology, losing all research points
class CancelResearchCommand : public Command {
   private:
      int researchProgress;
      int activeTechnologyID;
      int targetTechnologyID;
      int player;
   protected:
      
      GameActionID getID() const;
      ASCString getDescription() const;
      
      ActionResult go ( const Context& context ); 
      
      void readData ( tnstream& stream );
      void writeData ( tnstream& stream ) const;
      
      ActionResult undoAction( const Context& context );
      
   public:
      CancelResearchCommand( GameMap* map );
      ActionResult preCheck();
      void setPlayer( const Player& player );
      
      ASCString getCommandString() const ;
      
};


#endif

