#ifndef sessionh
#define sessionh

#include <glib.h>
#include <stdio.h>

#include <source.h>
#include <sink.h>

void session_register_source(Source *s);
void session_register_sink(Sink *s);

void session_unregister_source(Source *s);
void session_unregister_sink(Sink *s);

void session_reset();

void session_save(gchar *f);
void session_save_fd(FILE *f);
gboolean session_load(gchar *f);

#endif
