#include <unistd.h>
#include <sys/stat.h>

#include <source-default.h>

#include "source-fifo.h"

static gboolean _source_fifo_open(Source *s)
{
  SourceDefaultPrivate *p;
  g_assert(s);
  g_assert(p = (SourceDefaultPrivate*) s->private_data);

  g_assert(p->filename);
  if (access(p->filename, F_OK)) 
    mkfifo(p->filename, S_IRUSR|S_IWUSR); 

  return source_default_open_impl(s);
}

Source* source_fifo_new(gchar *shortname, gchar *fname)
{
  Source *s;
  char name[ASD_NAME_LENGTH];

  g_snprintf(name, sizeof(name), "Unix-FIFO %s", fname);
  g_assert(s = source_new(shortname, name, TRUE));

  g_assert(s->private_data = source_default_alloc_private(fname));

  s->type = "FIFO";
  s->open = _source_fifo_open;

  return s;
}
