#include <glib.h>

#include <recursive-lock.h>
#include <thread-manager.h>

static GSList *_threads = NULL;

static GStaticMutex _threads_mutex = G_STATIC_MUTEX_INIT;
static GStaticPrivate _threads_private = G_STATIC_PRIVATE_INIT;

#define _threads_lock() recursive_lock(&_threads_mutex, &_threads_private)
#define _threads_unlock() recursive_unlock(&_threads_mutex, &_threads_private)

static gint _func(gconstpointer a, gconstpointer b)
{
  g_assert(a && b);

  return *((pthread_t*) a) != *((pthread_t*) b);
}

static pthread_t* _find(pthread_t t)
{
  GSList *l;
  
  if ((l = g_slist_find_custom(_threads, &t, _func)))
    return (pthread_t*) l->data;

  return NULL;
}
void thread_register(pthread_t t)
{
  pthread_t *p;

  _threads_lock();

  if (!_find(t))
    {
      p = g_new(pthread_t, 1);
      *p = t;
      _threads = g_slist_prepend(_threads, p);

      //      g_printerr("Adding thread %li\n", t);
    }
  _threads_unlock();
}

void thread_unregister(pthread_t t)
{
  pthread_t *p;
  _threads_lock();
  
  if ((p = _find(t)))
    {
      _threads = g_slist_remove(_threads, p);
      //      g_printerr("Removing thread %li\n", t);
    }

  _threads_unlock();
}

void thread_killall()
{
  for (;;)
    {
      pthread_t t;

      _threads_lock();
      if (!_threads)
	{
	  _threads_unlock();
	  break;
	}
      g_assert(_threads->data);
      t = *((pthread_t*) _threads->data);
      _threads_unlock();

      //   g_printerr("Killing thread %li\n", t);
      pthread_cancel(t);
      pthread_join(t, NULL);
    }
}
