------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                        G N A T P P . O U T P U T                         --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            1.7
--                                                                          --
--                   Copyright (C) 2001-2004, ACT Europe                    --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by ACT Europe (http://www.act-europe.fr).           --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines various output routines

with Ada.Exceptions;      use Ada.Exceptions;

with GNATPP.Source_Table; use GNATPP.Source_Table;

package GNATPP.Output is

   procedure Set_Output (SF : SF_Id; Success : out Boolean);
   --  Creates or opens, if needed, and sets the output file for SF, depending
   --  on gnatpp options. Success is set ON if the output file has been
   --  successfully opened, and OFF otherwise

   procedure Set_Current_SF (SF : SF_Id);
   --  Stores the ID of the currently processed file in the variable in the
   --  package body. The main reason why we need this procedure is to minimize
   --  changes in the output routines when we move from one-source to
   --  multiple-source driver (CC12-005)

   procedure Brief_Help;
   --  Prints the brief help into the error stream.

   procedure Version_Info;
   --  Prints the version info the error stream.

   procedure Error (Diagnosis : Wide_String);
   --  Generates the error message to Stderr in the form:
   --  file:line:column: Diagnosis

   procedure Report_Unhandled_ASIS_Exception (Ex : Exception_Occurrence);
   --  Reports an unhandled ASIS exception

   procedure Report_Unhandled_Exception (Ex : Exception_Occurrence);
   --  Reports an unhandled non-ASIS exception

   procedure Report_Total_Failures;
   --  In case of multiple file processing reports into Stderr the summary
   --  info about all the failures (if any) detected when processing the
   --  argument sources. Does nothing in quiet mode.

   function PP_Suffix  return String;
   function NPP_Suffix return String;
   --  These functions return suffixes for the file names for default result
   --  and backup copy files. ('.pp' and '.npp' for all hosts but OpenVMS and
   --  '$PP' and '$NPP' for OpenVMS

end GNATPP.Output;
