------------------------------------------------------------------------------
--                                                                          --
--                           GNATELIM COMPONENTS                            --
--                                                                          --
--                     G N A T E L I M . S T R I N G S                      --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                     Copyright (C) 1998-2006 AdaCore.                     --
--                                                                          --
-- GNATELIM  is  free software;  you can  redistribute it and/or  modify it --
-- under the terms of the  GNU  General Public License  as published by the --
-- Free Software Foundation; either version 2 or (at your option) any later --
-- version. GNATELIM is distributed in the hope that it will be useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public Li- --
-- cense for  more details.  You should  have  received  a copy of the  GNU --
-- General Public License distributed with GNAT; see file COPYING.  If not, --
-- write to the  Free Software Foundation, 51 Franklin Street, Fifth Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
-- The original version  of  Gnatelim  was developed by  Alain  Le  Guennec --
-- It is now maintained by AdaCore (http://www.adacore.com)                 --
--                                                                          --
------------------------------------------------------------------------------

package body Gnatelim.Strings is

   ------------------
   -- Enter_String --
   ------------------

   function Enter_String (S : Wide_String) return String_Loc is
      Len   : constant Integer := S'Length;
      F     : constant Integer := Chars.Allocate (Len);
   begin
      Chars.Table (F .. F + Len - 1) := Chars.Table_Type (S);
      return String_Loc'(F, F + Len - 1);
   end Enter_String;

   ----------------
   -- Get_String --
   ----------------

   function Get_String (SL : String_Loc) return Wide_String is
   begin
      if SL = Empty_String then
         return "";
      else
         return Wide_String (Chars.Table (SL.First .. SL.Last));
      end if;
   end Get_String;

end Gnatelim.Strings;
