------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--              G N A T C H E C K . R U L E S . M E T R I C S               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                       Copyright (C) 2008, AdaCore                        --
--                                                                          --
-- GNATCHECK  is  free  software;  you can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATCHECK is maintained by AdaCore (http://www.adacore.com).             --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Strings;                    use Ada.Strings;
with Ada.Strings.Fixed;              use Ada.Strings.Fixed;

with ASIS_UL.Output;                 use ASIS_UL.Output;

with Gnatcheck.Rules.Metrics.Checks; use Gnatcheck.Rules.Metrics.Checks;
with Gnatcheck.Rules.Rule_Table;     use Gnatcheck.Rules.Rule_Table;

package body Gnatcheck.Rules.Metrics is

   ---------------
   -- Init_Rule --
   ---------------

   procedure Init_Rule (Rule : in out Metrics_Violation_Rule_Type) is
   begin
      Rule.Name       := new String'("Metrics_Violation");
      Rule.Rule_State := Disabled;
      Rule.Help_Info  := new String'("check metric values");
      --  This rule does not have a diagnosis on its own

   end Init_Rule;

   ----------------------------
   -- Process_Rule_Parameter --
   ----------------------------

   procedure Process_Rule_Parameter
     (Rule    : in out Metrics_Violation_Rule_Type;
      Param   :        String;
      Enable  :        Boolean)
   is
      Metrics_Violation_Rule_Id : Rule_Id;
      First_Idx, Last_Idx       : Natural;
   begin

      if Enable then

         First_Idx := Index (Param, ">");
         Last_Idx  := Index (Param, "<");

         if First_Idx > 0
           and then
            Last_Idx > 0
         then
            --  Parameter cannot contain both ">" and "<"
            Error ("(" & Rule.Name.all & ") wrong parameter: " & Param);
            return;
         elsif Last_Idx = 0 then
            --  No "<" in parameter, so
            Last_Idx := First_Idx;
         end if;

         if Last_Idx = 0 then
            Error ("(" & Rule.Name.all & ") wrong parameter: " & Param);
            return;
         end if;

         First_Idx                 := Param'First;
         Metrics_Violation_Rule_Id := Get_Rule
           (Trim (Source => Param (First_Idx .. Last_Idx - 1),
                  Side   => Right));

         if not Present (Metrics_Violation_Rule_Id) then
            Error ("(" & Rule.Name.all & ") wrong metric name : " &
                   Param (First_Idx .. Last_Idx - 1));
            return;
         elsif Internal_Rule_Template'Class
           (All_Rules.Table (Metrics_Violation_Rule_Id).all).
              Implements.Name.all /= "Metrics_Violation"
         then
            Error ("(" & Rule.Name.all & ") wrong metric name : " &
                   Param (First_Idx .. Last_Idx - 1));
            return;
         else
            --  If we are here, we have a valid metric name as a part of the
            --  rule parameter.

            Analyze_Metric_Parameter
              (Rule => Metric_Checks_Rule_Type'Class
                         (All_Rules.Table (Metrics_Violation_Rule_Id).all),
               Par  => Param (Last_Idx .. Param'Last));
         end if;

      else
         Metrics_Violation_Rule_Id := Get_Rule (Param);

         if Present (Metrics_Violation_Rule_Id) then

            if All_Rules.Table (Metrics_Violation_Rule_Id).all in
                  Metrics_Violation_Rule_Type'Class
            then
               All_Rules.Table (Metrics_Violation_Rule_Id).Rule_State :=
                 Disabled;
            else
               Error ("(" & Rule.Name.all & ") wrong metric name : " & Param);
            end if;

         else
            Error ("(" & Rule.Name.all & ") wrong metric name : " & Param);
         end if;

      end if;

   end Process_Rule_Parameter;

end Gnatcheck.Rules.Metrics;
