------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                    G N A T P P . P R O C E S S I N G                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                    Copyright (C) 2001-2013, AdaCore                      --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write to the Free Software Foundation,  51 Franklin Street, Fifth Floor, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by AdaCore (http://www.adacore.com)                 --
--                                                                          --
------------------------------------------------------------------------------

pragma Ada_2012;

--  This package contains routines performing the main processing needed
--  by the pretty-printer.

with Asis;                 use Asis;

with ASIS_UL.Source_Table; use ASIS_UL.Source_Table;

package GNATPP.Processing is

   procedure Pretty_Print (Unit : Asis.Compilation_Unit; SF : SF_Id);
   --  This is the ASIS pretty-printer - it generates the "pretty" source for
   --  Unit. SF is the index of the source file corresponding to this unit in
   --  GNATPP source table. We have placed this procedure into the spec to make
   --  it possible to use other drivers for pretty-printer.

end GNATPP.Processing;
