------------------------------------------------------------------------------
--                                                                          --
--                            GNAT2XML COMPONENTS                           --
--                                                                          --
--       G N A T 2 X M L . A D A _ T R E E S . A S I S _ T O _ T R E E      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2013, AdaCore, Inc.                    --
--                                                                          --
-- Gnat2xml is free software; you can redistribute it and/or modify it      --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Gnat2xml is distributed  in the hope  that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MER-      --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
-- The gnat2xml tool was derived from the Avatox sources.                   --
------------------------------------------------------------------------------

pragma Ada_2012;

--  The main thing this package provides is Compilation_Unit_To_Tree, for
--  converting ASIS elements into Ada_Trees. It also provides some helper
--  functions that are used by gnat2xml.

with Asis; use Asis;

package Ada_Trees.Asis_To_Tree is

   function Compilation_Unit_To_Tree
     (The_Unit : Asis.Compilation_Unit)
      return     Ada_Tree;
   --  Converts an ASIS compilation unit into an Ada_Tree

   function Decl_Of_Def_Id (Def_Id : Defining_Name) return Asis.Declaration;
   --  Return the declaration of the defining name

   function Decl_Kind (Def_Id : Defining_Name) return String;
   --  Return the "kind" string for the defining name. This is the 'Image of
   --  the Kind of Decl_Of_Def_Id (Def_Id), with "A_", "An_", "_Declaration",
   --  "_Specification" stripped off.

   function Enclosing_Def_Id (Def_Id : Defining_Name) return Asis.Element;
   --  Return the Defining_Name of the innermost enclosing declaration of
   --  Def_Id, or Nil_Element if Def_Id is a root library unit or Standard.
   --  If we have spec/body, we return the first (spec) one.

   function Unique_Id (Def_Id : Defining_Name) return String;
   --  Return a unique string globally identifying Def_Id

   --  The following _Value functions return the value of the relevant
   --  component of Ada_Tree_Rec; for example, Def_Value returns the value
   --  for the Def component.

   function Def_Value (Def_Id : Defining_Name) return String;
   function Def_Value
     (Def_Id : Defining_Name)
      return   Name_Id is
     (Name_Find (Def_Value (Def_Id)));

   function Def_Name_Value (Def_Id : Defining_Name) return String;
   function Def_Name_Value
     (Def_Id : Defining_Name)
      return   Name_Id is
     (Name_Find (Def_Name_Value (Def_Id)));

   function Ref_Value (Ref_Id : Asis.Name) return String;
   function Ref_Value
     (Ref_Id : Asis.Name)
      return   Name_Id is
     (Name_Find (Ref_Value (Ref_Id)));

   function Ref_Name_Value (Ref_Id : Asis.Name) return String;
   function Ref_Name_Value
     (Ref_Id : Asis.Name)
      return   Name_Id is
     (Name_Find (Ref_Name_Value (Ref_Id)));

   function Type_Value (Elem : Asis.Element) return String;
   function Type_Value
     (Elem : Asis.Element)
      return Name_Id is
     (Name_Find (Type_Value (Elem)));

end Ada_Trees.Asis_To_Tree;
