/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.result;

import java.io.CharConversionException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jd.util.StringUtil;
import jd.xml.util.Utf8Escaping;
import jd.xml.xpath.model.NamespaceContext;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.result.MarkupResultBuilder;
import jd.xml.xslt.result.NamespaceSupport;
import jd.xml.xslt.result.ResultLevel;
import jd.xml.xslt.result.output.Output;

public final class HtmlResultBuilder
extends MarkupResultBuilder {
    private Tag tag_;
    private HtmlLevel level_;
    private Utf8Escaping utf8Escaping_;
    private boolean textPrinted_;
    private boolean nonWhitespacePrinted_;
    private boolean inlineElementPrinted_;
    private Hashtable docTags_ = new Hashtable(20);
    private static final Tag defaultTag_ = new Tag();
    private static final Hashtable tags_ = new Hashtable(70);
    private static final String[] latinCharacters_;
    private static final boolean[] ESCAPE_TEXT_CHAR;
    private static final boolean[] ESCAPE_ATTR_CHAR;
    private static final boolean[] WHITESPACE_CHAR;

    public HtmlResultBuilder(XsltResult xsltResult) {
        super(xsltResult);
    }

    public void startDocument(OutputFormat outputFormat) {
        super.startDocument(outputFormat);
        this.indent_ = outputFormat.getIndent(true);
        this.level_ = new HtmlLevel();
        this.level_.level = -1;
        this.tag_ = this.level_.tag = defaultTag_;
        this.printDocumentStart();
    }

    private void printDocumentStart() {
        this.inlineElementPrinted_ = false;
        this.nonWhitespacePrinted_ = false;
        String string = this.outputFormat_.getDocTypeSystem();
        String string2 = this.outputFormat_.getDocTypePublic();
        if (string != null || string2 != null) {
            Output output = this.output_;
            output.printString("<!DOCTYPE HTML");
            if (string2 != null) {
                output.printString(" PUBLIC \"");
                output.printString(string2);
                output.printSmallByte('\"');
                if (string != null) {
                    output.printSmallByte(' ');
                    output.printSmallByte('\"');
                    output.printString(string);
                    output.printSmallByte('\"');
                }
            } else {
                output.printString(" SYSTEM \"");
                output.printString(string);
                output.printSmallByte('\"');
            }
            output.printSmallByte('>');
            this.println();
        }
    }

    public void startElement(String string, String string2, NamespaceContext namespaceContext, boolean bl) {
        this.flushNode(true);
        this.elementStarted_ = true;
        this.nsSupport_.startElement(string, namespaceContext, this.level_.namespaceContext);
        this.setTag(string2);
        HtmlLevel htmlLevel = this.level_ = (HtmlLevel)this.level_.increase();
        htmlLevel.tag = this.tag_;
        htmlLevel.name = string2;
        htmlLevel.namespaceContext = namespaceContext;
        htmlLevel.isCDataSectionElement = bl;
        htmlLevel.disableEscaping = this.tag_.isScript;
    }

    public void endElement() {
        this.flushNode(false);
        this.nsSupport_.endElement();
        Output output = this.output_;
        if (this.indent_ && !this.tag_.isInline) {
            this.decreasePrintIndent();
            if (!this.tag_.isEmpty) {
                this.printLineBreak();
                output.printSmallByte('<');
                output.printSmallByte('/');
                output.printString(this.level_.name);
                output.printSmallByte('>');
            }
        } else if (!this.tag_.isEmpty) {
            output.printSmallByte('<');
            output.printSmallByte('/');
            output.printString(this.level_.name);
            output.printSmallByte('>');
        }
        this.inlineElementPrinted_ = this.tag_.isInline;
        this.level_ = (HtmlLevel)this.level_.decrease();
        this.tag_ = this.level_.tag;
    }

    private void printAttributes() {
        Output output = this.output_;
        int n = this.attributes_.size();
        for (int i = 0; i < n; ++i) {
            String string = this.attributes_.getName(i);
            output.printSmallByte(' ');
            output.printString(string);
            if (this.tag_.isBooleanAttribute(string)) continue;
            output.printSmallByte('=');
            output.printSmallByte('\"');
            String string2 = this.attributes_.getValue(i);
            if (this.tag_.isUriAttribute(string)) {
                this.printUriAttributeValue(string2);
            } else {
                this.printAttributeValue(string2);
            }
            output.printSmallByte('\"');
        }
    }

    private void printAttributeValue(String string) {
        boolean[] blArray = ESCAPE_ATTR_CHAR;
        Output output = this.output_;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0080') {
                if (blArray[c]) {
                    this.printEscapedAttributeChar(c, string, i, n);
                    continue;
                }
                output.printSmallByte(c);
                continue;
            }
            if (!this.encoding_.isPrintable(c)) {
                i = this.printCharReference(c, string, i, n);
                continue;
            }
            output.printChar(c);
        }
    }

    private void printUriAttributeValue(String string) {
        boolean[] blArray = ESCAPE_ATTR_CHAR;
        Output output = this.output_;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '!' || c > '~' || c == '\"') {
                this.printUtf8AttributeChar(c);
                continue;
            }
            if (c < '\u0080' && blArray[c]) {
                this.printEscapedAttributeChar(c, string, i, n);
                continue;
            }
            output.printSmallByte(c);
        }
    }

    private void printEscapedAttributeChar(char c, String string, int n, int n2) {
        Output output = this.output_;
        output.printSmallByte('&');
        switch (c) {
            case '>': {
                output.printSmallByte('g');
                output.printSmallByte('t');
                break;
            }
            case '&': {
                if (n < n2 - 1 && string.charAt(n + 1) == '{') {
                    return;
                }
                output.printSmallByte('a');
                output.printSmallByte('m');
                output.printSmallByte('p');
                break;
            }
            case '\"': {
                output.printSmallByte('q');
                output.printSmallByte('u');
                output.printSmallByte('o');
                output.printSmallByte('t');
                break;
            }
            case '\n': {
                output.printSmallByte('#');
                output.printSmallByte('x');
                output.printSmallByte('a');
                break;
            }
            default: {
                throw new XsltException("unrecognized escape character '" + c + "'");
            }
        }
        output.printSmallByte(';');
    }

    private boolean isBrace(char[] cArray, int n, int n2) {
        return n < n2 && cArray[n] == '{';
    }

    private void printUtf8AttributeChar(char c) {
        try {
            if (this.utf8Escaping_ == null) {
                this.utf8Escaping_ = new Utf8Escaping();
            }
            int n = this.utf8Escaping_.escape(c);
            for (int i = 0; i < n; ++i) {
                this.output_.printSmallByte(this.utf8Escaping_.getResult(i));
            }
        }
        catch (CharConversionException charConversionException) {
            this.convertException(charConversionException);
        }
    }

    public void addTextUnescaped(String string) {
        this.level_.disableEscaping = true;
        this.addText(string);
        this.level_.disableEscaping = this.tag_.isScript;
    }

    public void addText(String string) {
        if (string.length() == 0) {
            return;
        }
        if (this.elementStarted_) {
            this.flushElement(true);
        }
        if (!this.textPrinted_) {
            this.textPrinted_ = true;
            if (this.level_.isCDataSectionElement) {
                this.output_.printString("<![CDATA[");
            }
        }
        if (this.level_.isCDataSectionElement) {
            string = StringUtil.replace(string, "]]>", "]]]]><![CDATA[>");
            this.output_.printString(string);
        } else if (this.level_.disableEscaping) {
            this.output_.printString(string);
        } else {
            this.printText(string);
        }
    }

    private void printText(String string) {
        char c;
        int n;
        boolean[] blArray;
        int n2 = string.length();
        Output output = this.output_;
        if (this.indent_ && !this.nonWhitespacePrinted_) {
            blArray = WHITESPACE_CHAR;
            for (n = 0; n < n2; ++n) {
                c = string.charAt(n);
                if (c >= '\u0080' || !blArray[c]) {
                    this.nonWhitespacePrinted_ = true;
                    break;
                }
                output.printSmallByte(c);
            }
        }
        blArray = ESCAPE_TEXT_CHAR;
        while (n < n2) {
            c = string.charAt(n);
            if (c < '\u0080') {
                if (blArray[c]) {
                    output.printSmallByte('&');
                    switch (c) {
                        case '<': {
                            output.printSmallByte('l');
                            output.printSmallByte('t');
                            break;
                        }
                        case '>': {
                            output.printSmallByte('g');
                            output.printSmallByte('t');
                            break;
                        }
                        case '&': {
                            output.printSmallByte('a');
                            output.printSmallByte('m');
                            output.printSmallByte('p');
                        }
                    }
                    output.printSmallByte(';');
                } else {
                    output.printSmallByte(c);
                }
            } else if (c >= '\u00a0' && c <= '\u00ff') {
                output.printSmallByte('&');
                output.printString(latinCharacters_[c - 160]);
                output.printSmallByte(';');
            } else {
                n = this.printCharReference(c, string, n, n2);
            }
            ++n;
        }
    }

    public void addProcessingInstruction(String string, String string2) {
        this.flushNode(true);
        if (this.indent_) {
            this.printLineBreak();
        }
        Output output = this.output_;
        output.printSmallByte('<');
        output.printSmallByte('?');
        output.printString(string);
        output.printSmallByte(' ');
        output.printString(string2);
        output.printSmallByte('>');
    }

    protected void flushNode(boolean bl) {
        if (this.elementStarted_) {
            this.flushElement(bl);
        } else if (this.textPrinted_) {
            this.textPrinted_ = false;
            this.inlineElementPrinted_ = false;
            if (this.level_.isCDataSectionElement) {
                this.output_.printString("]]>");
            }
        }
    }

    private void flushElement(boolean bl) {
        this.elementStarted_ = false;
        Output output = this.output_;
        if (this.indent_ && !this.tag_.isInline) {
            this.printLineBreak();
            output.printSmallByte('<');
            output.printString(this.level_.name);
            this.increasePrintIndent();
        } else {
            output.printSmallByte('<');
            output.printString(this.level_.name);
        }
        this.inlineElementPrinted_ = false;
        NamespaceSupport.Declaration declaration = this.nsSupport_.getElementDeclarations();
        while (declaration != null) {
            output.printSmallByte(' ');
            output.printString(declaration.getName());
            output.printSmallByte('=');
            output.printSmallByte('\"');
            output.printString(declaration.uri);
            output.printSmallByte('\"');
            declaration = declaration.next;
        }
        if (this.attributes_.size() > 0) {
            this.printAttributes();
            this.attributes_.clear();
        }
        output.printSmallByte('>');
        if (this.tag_.isHeadTag) {
            String string = this.level_.name.equals("head") ? "meta" : "META";
            String string2 = this.outputFormat_.getMediaType("text/html") + "; charset=" + this.encoding_.getName();
            this.startElement(null, string, null, false);
            this.addAttribute("http-equiv", null, null, "Content-Type");
            this.addAttribute("content", null, null, string2);
            this.endElement();
        }
    }

    protected void printLineBreak() {
        if (!this.nonWhitespacePrinted_ && !this.inlineElementPrinted_) {
            if (!this.outNewLine_) {
                this.println();
            }
            this.printIndent();
        }
        this.nonWhitespacePrinted_ = false;
    }

    private void setTag(String string) {
        this.tag_ = (Tag)this.docTags_.get(string);
        if (this.tag_ == null) {
            this.tag_ = (Tag)tags_.get(string.toLowerCase());
            if (this.tag_ == null) {
                this.tag_ = defaultTag_;
            }
            this.docTags_.put(string, this.tag_);
        }
    }

    private static Tag addTag(String string, boolean bl, boolean bl2, String string2, String string3) {
        Tag tag = new Tag();
        tags_.put(string, tag);
        tag.isEmpty = bl;
        tag.isInline = bl2;
        tag.booleanAttributes = HtmlResultBuilder.split(string2);
        tag.uriAttributes = HtmlResultBuilder.split(string3);
        return tag;
    }

    private static String[] split(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    static {
        ESCAPE_TEXT_CHAR = new boolean[128];
        HtmlResultBuilder.ESCAPE_TEXT_CHAR[60] = true;
        HtmlResultBuilder.ESCAPE_TEXT_CHAR[62] = true;
        HtmlResultBuilder.ESCAPE_TEXT_CHAR[38] = true;
        ESCAPE_ATTR_CHAR = new boolean[128];
        HtmlResultBuilder.ESCAPE_ATTR_CHAR[62] = true;
        HtmlResultBuilder.ESCAPE_ATTR_CHAR[38] = true;
        HtmlResultBuilder.ESCAPE_ATTR_CHAR[34] = true;
        HtmlResultBuilder.ESCAPE_ATTR_CHAR[10] = true;
        WHITESPACE_CHAR = new boolean[128];
        HtmlResultBuilder.WHITESPACE_CHAR[9] = true;
        HtmlResultBuilder.WHITESPACE_CHAR[32] = true;
        HtmlResultBuilder.WHITESPACE_CHAR[10] = true;
        HtmlResultBuilder.WHITESPACE_CHAR[13] = true;
        HtmlResultBuilder.addTag("a", false, true, null, "href*name");
        HtmlResultBuilder.addTag("abbr", false, true, null, null);
        HtmlResultBuilder.addTag("acronym", false, true, null, null);
        HtmlResultBuilder.addTag("applet", false, true, null, "codebase*href");
        HtmlResultBuilder.addTag("area", true, false, "nohref", null);
        HtmlResultBuilder.addTag("b", false, true, null, null);
        HtmlResultBuilder.addTag("base", true, false, null, "href");
        HtmlResultBuilder.addTag("basefont", true, true, null, null);
        HtmlResultBuilder.addTag("bdo", false, true, null, null);
        HtmlResultBuilder.addTag("big", false, true, null, null);
        HtmlResultBuilder.addTag("blockquote", false, false, null, "cite");
        HtmlResultBuilder.addTag("body", false, false, null, "background");
        HtmlResultBuilder.addTag("br", true, true, null, null);
        HtmlResultBuilder.addTag("button", false, true, "disabled", null);
        HtmlResultBuilder.addTag("cite", false, true, null, null);
        HtmlResultBuilder.addTag("code", false, true, null, null);
        HtmlResultBuilder.addTag("col", true, false, null, null);
        HtmlResultBuilder.addTag("dir", false, false, "compact", null);
        HtmlResultBuilder.addTag("del", false, false, null, "cite");
        HtmlResultBuilder.addTag("dl", false, false, "compact", null);
        HtmlResultBuilder.addTag("dfn", false, true, null, null);
        HtmlResultBuilder.addTag("em", false, true, null, null);
        HtmlResultBuilder.addTag("font", false, true, null, null);
        HtmlResultBuilder.addTag("form", false, false, null, "action");
        HtmlResultBuilder.addTag("frame", true, false, "noresize", "longdesc*src");
        HtmlResultBuilder.addTag((String)"head", (boolean)false, (boolean)false, null, (String)"profile").isHeadTag = true;
        HtmlResultBuilder.addTag("hr", true, false, "noshade", null);
        HtmlResultBuilder.addTag("i", false, true, null, null);
        HtmlResultBuilder.addTag("iframe", false, true, null, "longdesc*src");
        HtmlResultBuilder.addTag("img", true, true, "ismap", "longdesc*src*usemap");
        HtmlResultBuilder.addTag("input", true, true, "checked*disabled*readonly", "src*usemap");
        HtmlResultBuilder.addTag("ins", false, false, null, "cite");
        HtmlResultBuilder.addTag("isindex", true, false, null, null);
        HtmlResultBuilder.addTag("kbd", false, true, null, null);
        HtmlResultBuilder.addTag("label", false, true, null, null);
        HtmlResultBuilder.addTag("link", true, false, null, "href");
        HtmlResultBuilder.addTag("map", false, true, null, null);
        HtmlResultBuilder.addTag("menu", false, false, "compact", null);
        HtmlResultBuilder.addTag("meta", true, false, null, null);
        HtmlResultBuilder.addTag("object", false, true, "declare", "archive*classid*codebase*data*usemap");
        HtmlResultBuilder.addTag("ol", false, false, "compact", null);
        HtmlResultBuilder.addTag("option", false, false, "disabled*selected", null);
        HtmlResultBuilder.addTag("optgroup", false, false, "disabled", null);
        HtmlResultBuilder.addTag("param", true, false, null, null);
        HtmlResultBuilder.addTag((String)"pre", (boolean)false, (boolean)true, null, null).isPreFormatted = true;
        HtmlResultBuilder.addTag("q", false, true, null, "cite");
        HtmlResultBuilder.addTag("s", false, true, null, null);
        HtmlResultBuilder.addTag("samp", false, true, null, null);
        Tag tag = HtmlResultBuilder.addTag("script", false, false, "defer", "src*for");
        tag.isScript = true;
        tag.isPreFormatted = true;
        HtmlResultBuilder.addTag("select", false, true, "disabled*multiple*readonly", null);
        HtmlResultBuilder.addTag("small", false, true, null, null);
        HtmlResultBuilder.addTag("span", false, true, null, null);
        HtmlResultBuilder.addTag("strike", false, true, null, null);
        HtmlResultBuilder.addTag("strong", false, true, null, null);
        Tag tag2 = HtmlResultBuilder.addTag("style", false, false, null, null);
        tag2.isScript = true;
        tag2.isPreFormatted = true;
        HtmlResultBuilder.addTag("sub", false, true, null, null);
        HtmlResultBuilder.addTag("sup", false, true, null, null);
        HtmlResultBuilder.addTag("td", false, false, "nowrap", null);
        HtmlResultBuilder.addTag((String)"textarea", (boolean)false, (boolean)true, (String)"disabled*readonly", null).isPreFormatted = true;
        HtmlResultBuilder.addTag("th", false, false, "nowrap", null);
        HtmlResultBuilder.addTag("tt", false, true, null, null);
        HtmlResultBuilder.addTag("var", false, true, null, null);
        HtmlResultBuilder.addTag("ul", false, false, "compact", null);
        HtmlResultBuilder.addTag("var", false, true, null, null);
        latinCharacters_ = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    }

    private static class ElementInfo {
        public String name;
        public boolean isCDataSectionElement;
        public boolean isEmpty = true;
        public Tag tag;

        private ElementInfo() {
        }
    }

    private static class HtmlLevel
    extends ResultLevel {
        public String name;
        public NamespaceContext namespaceContext;
        public boolean isCDataSectionElement;
        public boolean disableEscaping;
        public Tag tag;

        private HtmlLevel() {
        }

        public ResultLevel create() {
            return new HtmlLevel();
        }
    }

    private static class Tag {
        String[] booleanAttributes;
        String[] uriAttributes;
        boolean isEmpty;
        boolean isInline;
        boolean isScript;
        boolean isPreFormatted;
        boolean isHeadTag;

        private Tag() {
        }

        public boolean isBooleanAttribute(String string) {
            if (this.booleanAttributes != null) {
                for (int i = this.booleanAttributes.length - 1; i >= 0; --i) {
                    if (!this.booleanAttributes[i].equalsIgnoreCase(string)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isUriAttribute(String string) {
            if (this.uriAttributes != null) {
                for (int i = this.uriAttributes.length - 1; i >= 0; --i) {
                    if (!this.uriAttributes[i].equalsIgnoreCase(string)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

