/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.codehaus.janino.Access;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.MethodDescriptor;

class ReflectionIClass
extends IClass {
    private Class clazz;
    private IClassLoader iClassLoader;
    static /* synthetic */ Class class$java$lang$String;

    public ReflectionIClass(Class clazz, IClassLoader iClassLoader) {
        this.clazz = clazz;
        this.iClassLoader = iClassLoader;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private IClass classToIClass(Class clazz) {
        IClass iClass;
        try {
            iClass = this.iClassLoader.loadIClass(Descriptor.fromClassName(clazz.getName()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Loading IClass \"" + clazz.getName() + "\": " + classNotFoundException);
        }
        if (iClass == null) {
            throw new RuntimeException("Cannot load class \"" + clazz.getName() + "\" through the given ClassLoader");
        }
        return iClass;
    }

    private IClass[] classesToIClasses(Class[] classArray) {
        IClass[] iClassArray = new IClass[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            iClassArray[n] = this.classToIClass(classArray[n]);
            ++n;
        }
        return iClassArray;
    }

    public Access getAccess() {
        return ReflectionIClass.modifiers2Access(this.clazz.getModifiers());
    }

    protected IClass getComponentType2() {
        Class<?> clazz = this.clazz.getComponentType();
        return clazz == null ? null : this.classToIClass(clazz);
    }

    protected IClass[] getDeclaredIClasses2() {
        return this.classesToIClasses(this.clazz.getDeclaredClasses());
    }

    protected IClass.IConstructor[] getDeclaredIConstructors2() {
        Constructor<?>[] constructorArray = this.clazz.getDeclaredConstructors();
        IClass.IConstructor[] iConstructorArray = new IClass.IConstructor[constructorArray.length];
        int n = 0;
        while (n < constructorArray.length) {
            iConstructorArray[n] = new ReflectionIConstructor(constructorArray[n]);
            ++n;
        }
        return iConstructorArray;
    }

    protected IClass.IField[] getDeclaredIFields2() {
        Field[] fieldArray = this.clazz.getDeclaredFields();
        IClass.IField[] iFieldArray = new IClass.IField[fieldArray.length];
        int n = 0;
        while (n < fieldArray.length) {
            iFieldArray[n] = new ReflectionIField(fieldArray[n]);
            ++n;
        }
        return iFieldArray;
    }

    protected IClass.IMethod[] getDeclaredIMethods2() {
        Method[] methodArray = this.clazz.getDeclaredMethods();
        ArrayList<IClass.IMethod> arrayList = new ArrayList<IClass.IMethod>();
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            if ((method.getModifiers() & 0x1000) == 0) {
                arrayList.add(new ReflectionIMethod(method));
            }
            ++n;
        }
        if (methodArray.length == 0 && this.clazz.isArray()) {
            arrayList.add(new IClass.IMethod(this){

                public Access getAccess() {
                    return Access.PUBLIC;
                }

                public String getName() {
                    return "clone";
                }

                public IClass[] getParameterTypes() throws CompileException {
                    return new IClass[0];
                }

                public IClass getReturnType() throws CompileException {
                    return ((ReflectionIClass)ReflectionIClass.this).iClassLoader.OBJECT;
                }

                public IClass[] getThrownExceptions() throws CompileException {
                    return new IClass[0];
                }

                public boolean isAbstract() {
                    return false;
                }

                public boolean isStatic() {
                    return false;
                }
            });
        }
        return arrayList.toArray(new IClass.IMethod[arrayList.size()]);
    }

    protected IClass getDeclaringIClass2() {
        Class<?> clazz = this.clazz.getDeclaringClass();
        if (clazz == null) {
            return null;
        }
        return this.classToIClass(clazz);
    }

    protected String getDescriptor2() {
        return Descriptor.fromClassName(this.clazz.getName());
    }

    protected IClass[] getInterfaces2() {
        return this.classesToIClasses(this.clazz.getInterfaces());
    }

    protected IClass getOuterIClass2() throws CompileException {
        if (Modifier.isStatic(this.clazz.getModifiers())) {
            return null;
        }
        return this.getDeclaringIClass();
    }

    protected IClass getSuperclass2() {
        Class clazz = this.clazz.getSuperclass();
        return clazz == null ? null : this.classToIClass(clazz);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.clazz.getModifiers());
    }

    public boolean isArray() {
        return this.clazz.isArray();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.clazz.getModifiers());
    }

    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public boolean isPrimitive() {
        return this.clazz.isPrimitive();
    }

    public boolean isPrimitiveNumeric() {
        return this.clazz == Byte.TYPE || this.clazz == Short.TYPE || this.clazz == Integer.TYPE || this.clazz == Long.TYPE || this.clazz == Character.TYPE || this.clazz == Float.TYPE || this.clazz == Double.TYPE;
    }

    private static Access modifiers2Access(int n) {
        return Modifier.isPrivate(n) ? Access.PRIVATE : (Modifier.isProtected(n) ? Access.PROTECTED : (Modifier.isPublic(n) ? Access.PUBLIC : Access.DEFAULT));
    }

    public String toString() {
        int n = 0;
        Class<?> clazz = this.clazz;
        while (clazz.isArray()) {
            ++n;
            clazz = clazz.getComponentType();
        }
        String string = clazz.getName();
        while (n-- > 0) {
            string = String.valueOf(string) + "[]";
        }
        return string;
    }

    private class ReflectionIConstructor
    extends IClass.IConstructor {
        final Constructor constructor;

        public ReflectionIConstructor(Constructor constructor) {
            this.constructor = constructor;
        }

        public Access getAccess() {
            int n = this.constructor.getModifiers();
            return ReflectionIClass.modifiers2Access(n);
        }

        public String getDescriptor() {
            Class<?>[] classArray = this.constructor.getParameterTypes();
            String[] stringArray = new String[classArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = Descriptor.fromClassName(classArray[n].getName());
                ++n;
            }
            return new MethodDescriptor(stringArray, "V").toString();
        }

        public IClass[] getParameterTypes() throws CompileException {
            IClass[] iClassArray = ReflectionIClass.this.classesToIClasses(this.constructor.getParameterTypes());
            IClass iClass = ReflectionIClass.this.getOuterIClass();
            if (iClass != null) {
                if (iClassArray.length < 1) {
                    throw new CompileException("Constructor \"" + this.constructor + "\" lacks synthetic enclosing instance parameter", null);
                }
                if (iClassArray[0] != iClass) {
                    throw new CompileException("Enclosing instance parameter of constructor \"" + this.constructor + "\" has wrong type -- \"" + iClassArray[0] + "\" vs. \"" + iClass + "\"", null);
                }
                IClass[] iClassArray2 = new IClass[iClassArray.length - 1];
                System.arraycopy(iClassArray, 1, iClassArray2, 0, iClassArray2.length);
                iClassArray = iClassArray2;
            }
            return iClassArray;
        }

        public IClass[] getThrownExceptions() {
            return ReflectionIClass.this.classesToIClasses(this.constructor.getExceptionTypes());
        }
    }

    private class ReflectionIMethod
    extends IClass.IMethod {
        final Method method;

        public ReflectionIMethod(Method method) {
            this.method = method;
        }

        public Access getAccess() {
            return ReflectionIClass.modifiers2Access(this.method.getModifiers());
        }

        public String getName() {
            return this.method.getName();
        }

        public IClass[] getParameterTypes() {
            return ReflectionIClass.this.classesToIClasses(this.method.getParameterTypes());
        }

        public IClass getReturnType() {
            return ReflectionIClass.this.classToIClass(this.method.getReturnType());
        }

        public IClass[] getThrownExceptions() {
            return ReflectionIClass.this.classesToIClasses(this.method.getExceptionTypes());
        }

        public boolean isAbstract() {
            return Modifier.isAbstract(this.method.getModifiers());
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.method.getModifiers());
        }
    }

    private class ReflectionIField
    extends IClass.IField {
        final Field field;

        public ReflectionIField(Field field) {
            this.field = field;
        }

        public Access getAccess() {
            return ReflectionIClass.modifiers2Access(this.field.getModifiers());
        }

        public Object getConstantValue() throws CompileException {
            int n = this.field.getModifiers();
            Class<?> clazz = this.field.getType();
            if (Modifier.isStatic(n) && Modifier.isFinal(n) && (clazz.isPrimitive() || clazz == (class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = ReflectionIClass.class$("java.lang.String"))))) {
                try {
                    return this.field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new CompileException("Field \"" + this.field.getName() + "\" is not accessible", null);
                }
            }
            return null;
        }

        public String getName() {
            return this.field.getName();
        }

        public IClass getType() {
            return ReflectionIClass.this.classToIClass(this.field.getType());
        }

        public boolean isStatic() {
            return Modifier.isStatic(this.field.getModifiers());
        }

        public String toString() {
            return String.valueOf(Descriptor.toString(this.getDeclaringIClass().getDescriptor())) + "." + this.getName();
        }
    }
}

