/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xpath.model;

import java.util.Vector;
import jd.xml.xpath.model.NodeName;

public class NodeNamePool {
    private static final int NAME_TABLE_SIZE = 17;
    private NameItem firstNameItem_;
    private UriItem firstUriItem_;
    private UriItem defaultUriItem_;
    private int nextNameId_;
    private int nextIndex_;
    private NodeNamePool createdFrom_;
    private boolean sealed_;
    private boolean preserveSpace_;

    public NodeNamePool(boolean bl) {
        this.preserveSpace_ = bl;
        this.firstUriItem_ = this.defaultUriItem_ = new UriItem(null, null, bl);
    }

    public NodeNamePool() {
        this(true);
    }

    public NodeNamePool(NodeNamePool nodeNamePool) {
        nodeNamePool.sealed_ = true;
        this.createdFrom_ = nodeNamePool;
        this.preserveSpace_ = nodeNamePool.preserveSpace_;
        this.firstNameItem_ = nodeNamePool.firstNameItem_;
        this.firstUriItem_ = nodeNamePool.firstUriItem_.copy();
        this.defaultUriItem_ = this.firstUriItem_.last();
        this.nextNameId_ = nodeNamePool.nextNameId_;
        this.nextIndex_ = nodeNamePool.nextIndex_;
    }

    public boolean isCreatedFrom(NodeNamePool nodeNamePool) {
        return this.createdFrom_ != null && (this.createdFrom_ == nodeNamePool || this.createdFrom_.isCreatedFrom(nodeNamePool));
    }

    public void setCDataSectionName(String string, String string2, String string3) {
        this.checkNameFlagChange();
        this.checkSealed();
        NodeName nodeName = this.getName(string, string2);
        if (nodeName == null) {
            nodeName = this.getName(string, string2, string3);
        }
        nodeName.setCDataSectionName();
    }

    public void setPreserveSpace(String string, String string2, String string3, boolean bl) {
        this.checkNameFlagChange();
        this.checkSealed();
        NodeName nodeName = this.getName(string, string2);
        if (nodeName == null) {
            nodeName = this.getName(string, string2, string3);
        }
        nodeName.setPreserveSpace(bl);
    }

    public void setPreserveSpace(String string, String string2, boolean bl) {
        this.checkNameFlagChange();
        this.checkSealed();
        string = this.normNamespaceUri(string);
        if (string2 != null) {
            NodeName nodeName = this.getName(string, string2);
            if (nodeName == null) {
                nodeName = this.getName(string, string2, string2);
            }
            nodeName.setPreserveSpace(bl);
        } else if (string != null) {
            this.getUriItem(string).nameTable.setPreserveSpace(bl);
        } else {
            this.preserveSpace_ = bl;
            UriItem uriItem = this.firstUriItem_;
            do {
                uriItem.nameTable.setPreserveSpace(bl);
            } while ((uriItem = uriItem.next) != null);
        }
    }

    public NodeName getName(String string, String string2, String string3) {
        UriItem uriItem = this.getUriItem(string = this.normNamespaceUri(string));
        NodeName nodeName = uriItem.nameTable.get(string2);
        if (nodeName == null) {
            NameTable nameTable = uriItem.nameTable;
            this.checkSealed();
            nodeName = new NodeName(string, string2, string3, uriItem.id, this.nextNameId_++, this.nextIndex_++);
            nodeName.setPreserveSpace(nameTable.preserveSpace);
            this.firstNameItem_ = new NameItem(nodeName, this.firstNameItem_);
            nameTable.put(string2, nodeName);
        } else if (string != null) {
            while (!nodeName.qname.equals(string3)) {
                if (nodeName.next_ != null) {
                    nodeName = nodeName.next_;
                    continue;
                }
                this.checkSealed();
                nodeName = new NodeName(nodeName, string3, this.nextIndex_++);
                uriItem.nameTable.put(string2, nodeName);
                this.firstNameItem_ = new NameItem(nodeName, this.firstNameItem_);
                break;
            }
        }
        return nodeName;
    }

    private NodeName getName(String string, String string2) {
        UriItem uriItem = this.getUriItem(this.normNamespaceUri(string));
        return uriItem.nameTable.get(string2);
    }

    public NodeName getName(String string, String string2, String string3, boolean bl) {
        NodeName nodeName = this.getName(string, string2, string3);
        if (bl) {
            this.setCDataSectionName(string, string2, string3);
        }
        return nodeName;
    }

    public NodeName getNamePattern(String string) {
        UriItem uriItem = this.getUriItem(string);
        return new NodeName(string, "", "", uriItem.id, -1, -1);
    }

    private UriItem getUriItem(String string) {
        UriItem uriItem = this.getExistingUriItem(string);
        if (uriItem == null) {
            uriItem = this.firstUriItem_ = new UriItem(string, this.firstUriItem_, this.preserveSpace_);
        }
        return uriItem;
    }

    private UriItem getExistingUriItem(String string) {
        if (string == null) {
            return this.defaultUriItem_;
        }
        UriItem uriItem = this.firstUriItem_;
        while (uriItem != null) {
            if (string.equals(uriItem.uri)) {
                return uriItem;
            }
            uriItem = uriItem.next;
        }
        return null;
    }

    public int size() {
        return this.nextNameId_;
    }

    public NodeName[] getNames() {
        Vector<NodeName> vector = new Vector<NodeName>();
        NameItem nameItem = this.firstNameItem_;
        while (nameItem != null) {
            vector.addElement(nameItem.nodeName);
            nameItem = nameItem.next;
        }
        int n = vector.size();
        NodeName[] nodeNameArray = new NodeName[n];
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            nodeNameArray[n3] = (NodeName)vector.elementAt(n2);
            --n3;
            ++n2;
        }
        return nodeNameArray;
    }

    public NodeName getNameForId(int n) {
        NameItem nameItem = this.firstNameItem_;
        while (nameItem != null) {
            if (((NameItem)nameItem).nodeName.nameId == n) {
                return nameItem.nodeName;
            }
            nameItem = nameItem.next;
        }
        return null;
    }

    private void checkNameFlagChange() {
        if (this.createdFrom_ != null) {
            throw new IllegalStateException("cannot modify name properties for a cloned pool");
        }
    }

    private void checkSealed() {
        if (this.sealed_) {
            throw new IllegalStateException("cannot modify a sealed name pool");
        }
    }

    public void seal() {
        this.sealed_ = true;
    }

    public boolean isSealed() {
        return this.sealed_;
    }

    private String normNamespaceUri(String string) {
        return string == null || string.length() > 0 ? string : null;
    }

    private static class NameItem {
        private final NodeName nodeName;
        private final NameItem next;

        public NameItem(NodeName nodeName, NameItem nameItem) {
            this.nodeName = nodeName;
            this.next = nameItem;
        }
    }

    private static class UriItem {
        private final String uri;
        private final UriItem next;
        private final int id;
        private final NameTable nameTable;

        public UriItem(String string, UriItem uriItem, boolean bl) {
            this(string, uriItem, new NameTable(bl));
        }

        public UriItem(String string, UriItem uriItem, NameTable nameTable) {
            this.uri = string;
            this.id = uriItem == null ? 0 : uriItem.id + 1;
            this.next = uriItem;
            this.nameTable = nameTable;
        }

        public UriItem copy() {
            return new UriItem(this.uri, this.next == null ? null : this.next.copy(), new NameTable(this.nameTable));
        }

        public UriItem last() {
            return this.next == null ? this : this.next.last();
        }
    }

    private static class NameTableEntry {
        private NodeName nodeName;
        private NameTable owner;
        private final int hashCode;
        private final String localName;
        private final NameTableEntry next;

        public NameTableEntry(NameTable nameTable, String string, NodeName nodeName, NameTableEntry nameTableEntry) {
            this.owner = nameTable;
            this.localName = string;
            this.hashCode = string.hashCode();
            this.nodeName = nodeName;
            this.next = nameTableEntry;
        }
    }

    private static class NameTable {
        private boolean preserveSpace;
        private NameTableEntry[] entries_;

        public NameTable(boolean bl) {
            this.preserveSpace = bl;
            this.entries_ = new NameTableEntry[17];
        }

        public NameTable(NameTable nameTable) {
            this.preserveSpace = nameTable.preserveSpace;
            this.entries_ = (NameTableEntry[])nameTable.entries_.clone();
        }

        public void setPreserveSpace(boolean bl) {
            this.preserveSpace = bl;
            for (int i = 0; i < 17; ++i) {
                NameTableEntry nameTableEntry = this.entries_[i];
                while (nameTableEntry != null) {
                    nameTableEntry.nodeName.setPreserveSpace(bl);
                    nameTableEntry = nameTableEntry.next;
                }
            }
        }

        public NodeName get(String string) {
            int n = string.hashCode();
            int n2 = string.charAt(0) % 17;
            NameTableEntry nameTableEntry = this.entries_[n2];
            while (nameTableEntry != null) {
                if (nameTableEntry.hashCode == n && nameTableEntry.localName.equals(string)) {
                    return nameTableEntry.nodeName;
                }
                nameTableEntry = nameTableEntry.next;
            }
            return null;
        }

        public void put(String string, NodeName nodeName) {
            int n = string.hashCode();
            int n2 = string.charAt(0) % 17;
            NameTableEntry nameTableEntry = this.entries_[n2];
            while (nameTableEntry != null) {
                if (nameTableEntry.hashCode == n && nameTableEntry.localName.equals(string)) {
                    if (nameTableEntry.owner != this) break;
                    nameTableEntry.nodeName = nodeName;
                    return;
                }
                nameTableEntry = nameTableEntry.next;
            }
            this.entries_[n2] = new NameTableEntry(this, string, nodeName, this.entries_[n2]);
        }
    }
}

