/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.AccessExp;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.UnboundLocationException;

public class ReferenceExp
extends AccessExp {
    static int counter;
    int id = ++counter;
    public static final int DONT_DEREFERENCE = 1;
    public static final int PROCEDURE_NAME = 2;
    public static final int PREFER_BINDING2 = 4;
    public static final int CREATE_FIELD_REFERENCE = 8;

    public final boolean getDontDereference() {
        return (this.flags & 1) != 0;
    }

    public final void setDontDereference(boolean setting) {
        this.setFlag(setting, 1);
    }

    public final boolean isUnknown() {
        return Declaration.isUnknown(this.binding);
    }

    public final boolean isProcedureName() {
        return (this.flags & 2) != 0;
    }

    public final void setProcedureName(boolean setting) {
        this.setFlag(setting, 2);
    }

    public ReferenceExp(Object symbol) {
        this.symbol = symbol;
    }

    public ReferenceExp(Object symbol, Declaration binding) {
        this.symbol = symbol;
        this.binding = binding;
    }

    public ReferenceExp(Declaration binding) {
        this(binding.getSymbol(), binding);
    }

    protected boolean mustCompile() {
        return false;
    }

    public void apply(CallContext ctx) throws Throwable {
        Object value;
        if (this.binding != null && this.binding.isAlias() && !this.getDontDereference() && this.binding.value instanceof ReferenceExp) {
            Expression v;
            ReferenceExp rexp = (ReferenceExp)this.binding.value;
            if (rexp.getDontDereference() && rexp.binding != null && ((v = rexp.binding.getValue()) instanceof QuoteExp || v instanceof ReferenceExp || v instanceof LambdaExp)) {
                v.apply(ctx);
                return;
            }
            value = this.binding.value.eval(ctx);
        } else if (this.binding != null && this.binding.field != null && this.binding.field.getDeclaringClass().isExisting() && (!this.getDontDereference() || this.binding.isIndirectBinding())) {
            try {
                Object instance = this.binding.field.getStaticFlag() ? null : this.contextDecl().getValue().eval(ctx);
                value = this.binding.field.getReflectField().get(instance);
            }
            catch (Exception ex) {
                String msg = "exception evaluating " + this.symbol + " from " + this.binding.field + " - " + ex;
                throw new UnboundLocationException((Object)msg, this);
            }
        } else if (this.binding != null && (this.binding.value instanceof QuoteExp || this.binding.value instanceof LambdaExp) && this.binding.value != QuoteExp.undefined_exp && (!this.getDontDereference() || this.binding.isIndirectBinding())) {
            value = this.binding.value.eval(ctx);
        } else {
            if (this.binding == null || this.binding.context instanceof ModuleExp && !this.binding.isPrivate()) {
                Object value2;
                Object property;
                Environment env = ctx.getEnvironment();
                Symbol sym = this.symbol instanceof Symbol ? (Symbol)this.symbol : env.getSymbol(this.symbol.toString());
                Object object2 = property = this.getFlag(4) && this.isProcedureName() ? EnvironmentKey.FUNCTION : null;
                if (this.getDontDereference()) {
                    value2 = env.getLocation(sym, property);
                } else {
                    String unb = Location.UNBOUND;
                    value2 = env.get(sym, property, unb);
                    if (value2 == unb) {
                        throw new UnboundLocationException((Object)sym, this);
                    }
                }
                ctx.writeValue(value2);
                return;
            }
            value = ctx.evalFrames[ScopeExp.nesting(this.binding.context)][this.binding.evalIndex];
        }
        if (!this.getDontDereference() && this.binding.isIndirectBinding()) {
            value = ((Location)value).get();
        }
        ctx.writeValue(value);
    }

    public void compile(Compilation comp, Target target) {
        if (!(target instanceof ConsumerTarget) || !((ConsumerTarget)target).compileWrite(this, comp)) {
            this.binding.load(this, this.flags, comp, target);
        }
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkReferenceExp(this);
    }

    public Expression inline(ApplyExp exp, InlineCalls walker, Declaration decl) {
        decl = this.binding;
        if (decl != null && !decl.getFlag(65536)) {
            if ((decl = Declaration.followAliases(decl)).isIndirectBinding()) {
                return exp;
            }
            Expression dval = decl.getValue();
            if (dval != null) {
                return dval.inline(exp, walker, decl);
            }
        } else if (this.getSymbol() instanceof Symbol) {
            Symbol symbol = (Symbol)this.getSymbol();
            Object fval = Environment.getCurrent().getFunction(symbol, null);
            if (fval instanceof Procedure) {
                return new QuoteExp(fval).inline(exp, walker, null);
            }
        }
        return exp;
    }

    public void print(OutPort ps) {
        ps.print("(Ref/");
        ps.print(this.id);
        if (this.symbol != null && (this.binding == null || this.symbol.toString() != this.binding.getName())) {
            ps.print('/');
            ps.print(this.symbol);
        }
        if (this.binding != null) {
            ps.print('/');
            ps.print(this.binding);
        }
        ps.print(")");
    }

    public Type getType() {
        Expression value;
        Declaration decl = this.binding;
        if (decl == null || decl.isFluid()) {
            return Type.pointer_type;
        }
        if (this.getDontDereference()) {
            return Compilation.typeLocation;
        }
        Type type = (decl = Declaration.followAliases(decl)).getType();
        if ((type == null || type == Type.pointer_type) && (value = decl.getValue()) != null) {
            Expression save = decl.value;
            decl.value = null;
            type = value.getType();
            decl.value = save;
        }
        return type;
    }

    public boolean side_effects() {
        return this.binding == null || !this.binding.isLexical();
    }

    public String toString() {
        return "RefExp/" + this.symbol + '/' + this.id + '/';
    }
}

