/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import net.sf.saxon.om.Item;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;

public class TimedTraceListener
implements TraceListener {
    private int indent = 0;
    private static StringBuffer spaceBuffer = new StringBuffer("                ");

    public void open() {
        System.err.println("<trace time=\"" + System.currentTimeMillis() + "\">");
    }

    public void close() {
        System.err.println("<end time=\"" + System.currentTimeMillis() + "\"/></trace>");
    }

    public void enter(InstructionInfo instructionInfo) {
        String string = instructionInfo.getSystemId();
        if (string == null) {
            string = "";
        }
        if (string.length() > 15) {
            string = "*" + string.substring(string.length() - 14);
        }
        String string2 = instructionInfo.getInstructionName();
        System.err.println(TimedTraceListener.spaces(this.indent) + "<Instruction element=\"" + string2 + "\" line=\"" + instructionInfo.getLineNumber() + "\" file=\"" + string + "\" time=\"" + System.currentTimeMillis() + (string2.equals("xsl:apply-templates") ? "\" mode=\"" + instructionInfo.getProperty("mode") : "") + "\">");
        ++this.indent;
    }

    public void leave(InstructionInfo instructionInfo) {
        --this.indent;
        System.err.println(TimedTraceListener.spaces(this.indent) + "<end time=\"" + System.currentTimeMillis() + "\"/></Instruction>");
    }

    public void startCurrentItem(Item item) {
    }

    public void endCurrentItem(Item item) {
    }

    private static String spaces(int n) {
        if (spaceBuffer.length() < n) {
            spaceBuffer.append(spaceBuffer);
        }
        return spaceBuffer.substring(0, n);
    }
}

