/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt;

import java.io.IOException;
import java.util.Vector;
import jd.xml.util.UriResolver;
import jd.xml.util.XmlSource;
import jd.xml.xpath.model.NodeNamePool;
import jd.xml.xslt.MessageListener;
import jd.xml.xslt.Transformation;
import jd.xml.xslt.XsltException;
import jd.xml.xslt.XsltResult;
import jd.xml.xslt.XsltSecurityManager;
import jd.xml.xslt.format.OutputFormat;
import jd.xml.xslt.result.ModelResultBuilder;
import jd.xml.xslt.util.VerboseLog;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class TransformationChain
extends Transformation {
    private Vector transformations_ = new Vector();

    public void addTransformation(Transformation transformation) {
        this.transformations_.addElement(transformation);
    }

    public void transform(XmlSource xmlSource, XsltResult xsltResult, int n) throws IOException, SAXException {
        int n2 = this.transformations_.size();
        for (int i = 0; i < n2; ++i) {
            Transformation transformation = this.getTransformation(i);
            if (i == n2 - 1) {
                transformation.transform(xmlSource, xsltResult);
                continue;
            }
            Transformation transformation2 = this.getTransformation(i + 1);
            ModelResultBuilder modelResultBuilder = new ModelResultBuilder("", transformation2.getNodeNamePool());
            XsltResult xsltResult2 = new XsltResult(modelResultBuilder);
            transformation.transform(xmlSource, xsltResult2);
            xmlSource = new XmlSource(xmlSource.getUri(), modelResultBuilder.getDocumentRoot());
        }
    }

    public boolean setParameter(String string, Object object) {
        boolean bl = false;
        int n = this.transformations_.size();
        for (int i = 0; i < n; ++i) {
            if (!this.getTransformation(i).setParameter(string, object)) continue;
            bl = true;
        }
        return bl;
    }

    public void clearParameters() {
        int n = this.transformations_.size();
        for (int i = 0; i < n; ++i) {
            this.getTransformation(i).clearParameters();
        }
    }

    public void setWarningLevel(int n) {
        int n2 = this.transformations_.size();
        for (int i = 0; i < n2; ++i) {
            this.getTransformation(i).setWarningLevel(n);
        }
    }

    public void setValidate(boolean bl) {
        int n = this.transformations_.size();
        for (int i = 0; i < n; ++i) {
            this.getTransformation(i).setValidate(bl);
        }
    }

    public void setTrace(boolean bl) {
        int n = this.transformations_.size();
        for (int i = 0; i < n; ++i) {
            this.getTransformation(i).setTrace(bl);
        }
    }

    public void setUriResolver(UriResolver uriResolver) {
        int n = this.transformations_.size();
        for (int i = 0; i < n; ++i) {
            this.getTransformation(i).setUriResolver(uriResolver);
        }
    }

    public void setMessageListener(MessageListener messageListener) {
        int n = this.transformations_.size();
        for (int i = 0; i < n; ++i) {
            this.getTransformation(i).setMessageListener(messageListener);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        int n = this.transformations_.size();
        for (int i = 0; i < n; ++i) {
            this.getTransformation(i).setEntityResolver(entityResolver);
        }
    }

    public OutputFormat getOutputFormat() {
        int n = this.size();
        if (n == 0) {
            throw new XsltException("TransformationChain is empty");
        }
        return this.getTransformation(n - 1).getOutputFormat();
    }

    public void setSecurityManager(XsltSecurityManager xsltSecurityManager) {
        int n = this.transformations_.size();
        for (int i = 0; i < n; ++i) {
            this.getTransformation(i).setSecurityManager(xsltSecurityManager);
        }
    }

    public NodeNamePool getNodeNamePool() {
        return this.transformations_.size() == 0 ? null : this.getTransformation(0).getNodeNamePool();
    }

    public void setVerboseLog(VerboseLog verboseLog) {
        int n = this.transformations_.size();
        for (int i = 0; i < n; ++i) {
            this.getTransformation(i).setVerboseLog(verboseLog);
        }
    }

    public int size() {
        return this.transformations_.size();
    }

    public Transformation getTransformation(int n) {
        return (Transformation)this.transformations_.elementAt(n);
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println();
        System.out.println("The functionality of TransformationChain is now directly available from the");
        System.out.println("command-line of the Stylesheet class.");
        System.out.println();
    }
}

