/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.expr.ThisExp;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.KeyPair;
import gnu.mapping.Symbol;
import java.io.Externalizable;
import java.util.Hashtable;

public class FindCapturedVars
extends ExpWalker {
    Hashtable unknownDecls = null;
    ModuleExp currentModule = null;

    public static void findCapturedVars(Expression exp, Compilation comp) {
        FindCapturedVars walker = new FindCapturedVars();
        walker.setContext(comp);
        exp.walk(walker);
    }

    protected Expression walkApplyExp(ApplyExp exp) {
        LambdaExp lexp;
        Expression value;
        Declaration decl;
        boolean skipFunc = false;
        if (exp.func instanceof ReferenceExp && Compilation.defaultCallConvention <= 1 && (decl = Declaration.followAliases(((ReferenceExp)exp.func).binding)) != null && decl.context instanceof ModuleExp && !decl.isPublic() && !decl.getFlag(4096) && (value = decl.getValue()) instanceof LambdaExp && !(lexp = (LambdaExp)value).getNeedsClosureEnv()) {
            skipFunc = true;
        }
        if (!skipFunc) {
            exp.func = exp.func.walk(this);
        }
        if (this.exitValue == null) {
            exp.args = this.walkExps(exp.args);
        }
        return exp;
    }

    public void walkDefaultArgs(LambdaExp exp) {
        if (exp.defaultArgs == null) {
            return;
        }
        super.walkDefaultArgs(exp);
        for (Declaration param = exp.firstDecl(); param != null; param = param.nextDecl()) {
            if (param.isSimple()) continue;
            exp.setFlag(true, 512);
            break;
        }
    }

    protected Expression walkClassExp(ClassExp exp) {
        Expression ret = super.walkClassExp(exp);
        if (!exp.explicitInit && !exp.getNeedsClosureEnv()) {
            Compilation.getConstructor(exp.instanceType, exp);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkModuleExp(ModuleExp exp) {
        ModuleExp saveModule = this.currentModule;
        Hashtable saveDecls = this.unknownDecls;
        this.currentModule = exp;
        this.unknownDecls = null;
        try {
            Expression expression = this.walkLambdaExp(exp);
            return expression;
        }
        finally {
            this.currentModule = saveModule;
            this.unknownDecls = saveDecls;
        }
    }

    protected Expression walkFluidLetExp(FluidLetExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (decl.base != null) continue;
            Declaration bind = this.allocUnboundDecl(decl.getSymbol(), false);
            this.capture(bind);
            decl.base = bind;
        }
        return super.walkLetExp(exp);
    }

    protected Expression walkLetExp(LetExp exp) {
        if (exp.body instanceof BeginExp) {
            Expression[] inits = exp.inits;
            int len = inits.length;
            Expression[] exps = ((BeginExp)exp.body).exps;
            int init_index = 0;
            Declaration decl = exp.firstDecl();
            for (int begin_index = 0; begin_index < exps.length && init_index < len; ++begin_index) {
                Expression st = exps[begin_index];
                if (!(st instanceof SetExp)) continue;
                SetExp set = (SetExp)st;
                if (set.binding != decl || inits[init_index] != QuoteExp.nullExp || !set.isDefining()) continue;
                Expression new_value = set.new_value;
                if ((new_value instanceof QuoteExp || new_value instanceof LambdaExp) && decl.getValue() == new_value) {
                    inits[init_index] = new_value;
                    exps[begin_index] = QuoteExp.voidExp;
                }
                ++init_index;
                decl = decl.nextDecl();
            }
        }
        return super.walkLetExp(exp);
    }

    public void capture(Declaration decl) {
        LambdaExp declValue;
        if (!decl.getCanRead() && !decl.getCanCall()) {
            return;
        }
        if (decl.field != null && decl.field.getStaticFlag()) {
            return;
        }
        LambdaExp curLambda = this.getCurrentLambda();
        LambdaExp declLambda = decl.getContext().currentLambda();
        LambdaExp oldParent = null;
        LambdaExp chain = null;
        while (curLambda != declLambda && curLambda.getInlineOnly()) {
            LambdaExp curParent = curLambda.outerLambda();
            if (curParent != oldParent) {
                chain = curParent.firstChild;
                oldParent = curParent;
            }
            ApplyExp curReturn = curLambda.returnContinuation;
            if (chain == null || curReturn == null) {
                curLambda.setCanCall(false);
                return;
            }
            curLambda = curReturn.context;
            chain = chain.nextSibling;
        }
        if (this.comp.usingCPStyle() ? curLambda instanceof ModuleExp : curLambda == declLambda) {
            return;
        }
        Expression value = decl.getValue();
        if (value == null || !(value instanceof LambdaExp)) {
            declValue = null;
        } else {
            declValue = (LambdaExp)value;
            if (declValue.getInlineOnly()) {
                return;
            }
            if (declValue.isHandlingTailCalls()) {
                declValue = null;
            } else if (declValue == curLambda && !decl.getCanRead()) {
                return;
            }
        }
        if (decl.getFlag(65536)) {
            for (LambdaExp parent = curLambda; parent != declLambda; parent = parent.outerLambda()) {
                if (parent.nameDecl == null || !parent.nameDecl.getFlag(2048)) continue;
                decl.setFlag(2048);
                break;
            }
        }
        if (decl.base != null) {
            decl.base.setCanRead(true);
            this.capture(decl.base);
        } else if (decl.getCanRead() || declValue == null) {
            if (!decl.isStatic()) {
                LambdaExp parent;
                LambdaExp heapLambda = curLambda;
                heapLambda.setImportsLexVars();
                LambdaExp outer = parent = heapLambda.outerLambda();
                while (outer != declLambda && outer != null) {
                    heapLambda = outer;
                    if (!decl.getCanRead() && declValue == outer) break;
                    Declaration heapDecl = heapLambda.nameDecl;
                    if (heapDecl != null && heapDecl.getFlag(2048)) {
                        this.comp.error('e', "static " + heapLambda.getName() + " references non-static " + decl.getName());
                    }
                    heapLambda.setNeedsStaticLink();
                    outer = heapLambda.outerLambda();
                }
            }
            declLambda.capture(decl);
        }
    }

    Declaration allocUnboundDecl(Object name, boolean function2) {
        Declaration decl;
        Object key = name;
        if (function2 && name instanceof Symbol) {
            if (!this.getCompilation().getLanguage().hasSeparateFunctionNamespace()) {
                function2 = false;
            } else {
                key = new KeyPair((Symbol)name, EnvironmentKey.FUNCTION);
            }
        }
        if (this.unknownDecls == null) {
            this.unknownDecls = new Hashtable(100);
            decl = null;
        } else {
            decl = (Declaration)this.unknownDecls.get(key);
        }
        if (decl == null) {
            decl = this.currentModule.addDeclaration(name);
            decl.setSimple(false);
            decl.setPrivate(true);
            if (function2) {
                decl.setProcedureDecl(true);
            }
            if (this.currentModule.isStatic()) {
                decl.setFlag(2048);
            }
            decl.setCanRead(true);
            decl.setFlag(65536);
            decl.setIndirectBinding(true);
            this.unknownDecls.put(key, decl);
        }
        return decl;
    }

    protected Expression walkReferenceExp(ReferenceExp exp) {
        Declaration decl = exp.getBinding();
        if (decl == null) {
            decl = this.allocUnboundDecl(exp.getSymbol(), exp.isProcedureName());
            exp.setBinding(decl);
        }
        if (decl.getFlag(65536)) {
            Object resolved;
            Type type = this.getCompilation().getLanguage().getTypeFor(exp);
            if (type instanceof Externalizable && !exp.getDontDereference()) {
                return new QuoteExp(type);
            }
            if (this.comp.getBooleanOption("warn-undefined-variable", false) && (resolved = this.comp.resolve(exp.getSymbol(), exp.isProcedureName())) == null) {
                this.comp.error('w', "no declaration seen for " + exp.getName(), exp);
            }
        }
        this.capture(exp.contextDecl(), decl);
        return exp;
    }

    void capture(Declaration containing, Declaration decl) {
        if (decl.isAlias() && decl.value instanceof ReferenceExp) {
            ReferenceExp rexp = (ReferenceExp)decl.value;
            Declaration orig = rexp.binding;
            if (!(orig == null || containing != null && orig.needsContext())) {
                this.capture(rexp.contextDecl(), orig);
                return;
            }
        }
        if (containing != null && decl.needsContext()) {
            this.capture(containing);
        } else {
            this.capture(decl);
        }
    }

    protected Expression walkThisExp(ThisExp exp) {
        if (exp.isForContext()) {
            this.getCurrentLambda().setImportsLexVars();
            return exp;
        }
        return this.walkReferenceExp(exp);
    }

    protected Expression walkSetExp(SetExp exp) {
        Declaration decl = exp.binding;
        if (decl == null) {
            exp.binding = decl = this.allocUnboundDecl(exp.getSymbol(), exp.isFuncDef());
        }
        if (!decl.ignorable()) {
            if (!exp.isDefining()) {
                decl = Declaration.followAliases(decl);
            }
            this.capture(exp.contextDecl(), decl);
        }
        return super.walkSetExp(exp);
    }
}

