/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.CoverageDataContainer;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.SaveTimer;
import net.sourceforge.cobertura.util.FileLocker;

public class ProjectData
extends CoverageDataContainer
implements HasBeenInstrumented {
    private static final long serialVersionUID = 6L;
    private static ProjectData globalProjectData = null;
    private static SaveTimer saveTimer = null;
    private Map classes = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$ClassData;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$CoverageData;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$CoverageDataContainer;
    static /* synthetic */ Class class$net$sourceforge$cobertura$util$FileLocker;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$HasBeenInstrumented;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$LineData;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$PackageData;
    static /* synthetic */ Class class$net$sourceforge$cobertura$coveragedata$SourceFileData;

    public void addClassData(ClassData classData) {
        String packageName = classData.getPackageName();
        PackageData packageData = (PackageData)this.children.get(packageName);
        if (packageData == null) {
            packageData = new PackageData(packageName);
            this.children.put(packageName, packageData);
        }
        packageData.addClassData(classData);
        this.classes.put(classData.getName(), classData);
    }

    public ClassData getClassData(String name) {
        return (ClassData)this.classes.get(name);
    }

    public synchronized ClassData getOrCreateClassData(String name) {
        ClassData classData = (ClassData)this.classes.get(name);
        if (classData == null) {
            classData = new ClassData(name);
            this.addClassData(classData);
        }
        return classData;
    }

    public Collection getClasses() {
        return this.classes.values();
    }

    public int getNumberOfClasses() {
        return this.classes.size();
    }

    public int getNumberOfSourceFiles() {
        return this.getSourceFiles().size();
    }

    public SortedSet getPackages() {
        return new TreeSet(this.children.values());
    }

    public Collection getSourceFiles() {
        TreeSet sourceFileDatas = new TreeSet();
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            PackageData packageData = (PackageData)iter.next();
            sourceFileDatas.addAll(packageData.getSourceFiles());
        }
        return sourceFileDatas;
    }

    public SortedSet getSubPackages(String packageName) {
        TreeSet<PackageData> subPackages = new TreeSet<PackageData>();
        Iterator iter = this.children.values().iterator();
        while (iter.hasNext()) {
            PackageData packageData = (PackageData)iter.next();
            if (!packageData.getName().startsWith(packageName)) continue;
            subPackages.add(packageData);
        }
        return subPackages;
    }

    public void merge(CoverageData coverageData) {
        super.merge(coverageData);
        ProjectData projectData = (ProjectData)coverageData;
        Iterator iter = projectData.classes.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (this.classes.containsKey(key)) continue;
            this.classes.put(key, projectData.classes.get(key));
        }
    }

    public static ProjectData getGlobalProjectData() {
        if (globalProjectData != null) {
            return globalProjectData;
        }
        globalProjectData = new ProjectData();
        ProjectData.initialize();
        return globalProjectData;
    }

    private static void initialize() {
        if (System.getProperty("catalina.home") != null) {
            ProjectData.saveGlobalProjectData();
            (class$net$sourceforge$cobertura$coveragedata$ClassData == null ? (class$net$sourceforge$cobertura$coveragedata$ClassData = ProjectData.class$("net.sourceforge.cobertura.coveragedata.ClassData")) : class$net$sourceforge$cobertura$coveragedata$ClassData).toString();
            (class$net$sourceforge$cobertura$coveragedata$CoverageData == null ? (class$net$sourceforge$cobertura$coveragedata$CoverageData = ProjectData.class$("net.sourceforge.cobertura.coveragedata.CoverageData")) : class$net$sourceforge$cobertura$coveragedata$CoverageData).toString();
            (class$net$sourceforge$cobertura$coveragedata$CoverageDataContainer == null ? (class$net$sourceforge$cobertura$coveragedata$CoverageDataContainer = ProjectData.class$("net.sourceforge.cobertura.coveragedata.CoverageDataContainer")) : class$net$sourceforge$cobertura$coveragedata$CoverageDataContainer).toString();
            (class$net$sourceforge$cobertura$util$FileLocker == null ? (class$net$sourceforge$cobertura$util$FileLocker = ProjectData.class$("net.sourceforge.cobertura.util.FileLocker")) : class$net$sourceforge$cobertura$util$FileLocker).toString();
            (class$net$sourceforge$cobertura$coveragedata$HasBeenInstrumented == null ? (class$net$sourceforge$cobertura$coveragedata$HasBeenInstrumented = ProjectData.class$("net.sourceforge.cobertura.coveragedata.HasBeenInstrumented")) : class$net$sourceforge$cobertura$coveragedata$HasBeenInstrumented).toString();
            (class$net$sourceforge$cobertura$coveragedata$LineData == null ? (class$net$sourceforge$cobertura$coveragedata$LineData = ProjectData.class$("net.sourceforge.cobertura.coveragedata.LineData")) : class$net$sourceforge$cobertura$coveragedata$LineData).toString();
            (class$net$sourceforge$cobertura$coveragedata$PackageData == null ? (class$net$sourceforge$cobertura$coveragedata$PackageData = ProjectData.class$("net.sourceforge.cobertura.coveragedata.PackageData")) : class$net$sourceforge$cobertura$coveragedata$PackageData).toString();
            (class$net$sourceforge$cobertura$coveragedata$SourceFileData == null ? (class$net$sourceforge$cobertura$coveragedata$SourceFileData = ProjectData.class$("net.sourceforge.cobertura.coveragedata.SourceFileData")) : class$net$sourceforge$cobertura$coveragedata$SourceFileData).toString();
        }
        saveTimer = new SaveTimer();
        Runtime.getRuntime().addShutdownHook(new Thread(saveTimer));
    }

    public static void saveGlobalProjectData() {
        ProjectData projectDataToSave = globalProjectData;
        globalProjectData = new ProjectData();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        File dataFile = CoverageDataFileHandler.getDefaultDataFile();
        FileLocker fileLocker = new FileLocker(dataFile);
        if (fileLocker.lock()) {
            ProjectData datafileProjectData = ProjectData.loadCoverageDataFromDatafile(dataFile);
            if (datafileProjectData == null) {
                datafileProjectData = projectDataToSave;
            } else {
                datafileProjectData.merge(projectDataToSave);
            }
            CoverageDataFileHandler.saveCoverageData(datafileProjectData, dataFile);
        }
        fileLocker.release();
    }

    private static ProjectData loadCoverageDataFromDatafile(File dataFile) {
        ProjectData projectData = null;
        if (dataFile.isFile()) {
            projectData = CoverageDataFileHandler.loadCoverageData(dataFile);
        }
        if (projectData == null) {
            System.out.println("Cobertura: Coverage data file " + dataFile.getAbsolutePath() + " either does not exist or is not readable.  Creating a new data file.");
        }
        return projectData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

