// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __AdviceCode_h__
#define __AdviceCode_h__

#include "ThisJoinPoint.h"
#include "Binding.h"

#include "Puma/ACTree.h"
#include "Puma/CFunctionInfo.h"
#include "Puma/CScopeInfo.h"
#include "Puma/CClassInfo.h"
using namespace Puma;

#include <iostream>
using std::ostream;
#include <sstream>
using std::stringstream;

class AspectInfo;

enum advice_type { ADVICE_BEFORE, ADVICE_AROUND, ADVICE_AFTER };

class AdviceCode {
protected:
  CT_AdviceDecl *_tree;
  advice_type _type;
  ThisJoinPoint _this_join_point;
  Binding _binding;

public:
  AdviceCode (CT_AdviceDecl *ad) : _tree (ad) {
    const char *nm = name ();
    if (strstr (nm, "before"))
      _type = ADVICE_BEFORE;
    else if (strstr (nm, "after"))
      _type = ADVICE_AFTER;
    else
      _type = ADVICE_AROUND;
  }
  CScopeInfo *Scope () {
   return ((CT_FctDef*)_tree->Decl ())->Object ()->QualifiedScope ();
  }
  const char *name () {
   return ((CT_FctDef*)_tree->Decl ())->Object ()->Name ();
  }
  advice_type type () { return _type; }
  const char *type_str () {
    switch (_type) {
      case ADVICE_BEFORE: return "before";
      case ADVICE_AROUND: return "around";
      case ADVICE_AFTER: return "after";
    }
    return "error"; // just to suppress warnings
  }
  int line () const { return _tree->token ()->location ().line (); }
  int lines () {
    return function()->Tree()->end_token()->location().line() - line () + 1;
  }
  const Unit &unit () const {
   return *(Unit*)_tree->token ()->belonging_to ();
  }
  CT_AdviceDecl *tree () const { return _tree; }
  Binding &binding () { return _binding; }
  ThisJoinPoint &this_join_point () { return _this_join_point; }
  CFunctionInfo *function() {
    stringstream fname;
    fname << "__" << (name () + 1) << ends;
    return Scope ()->ClassInfo ()->Function (fname.str ().data ());
  }
};

#endif // __AdviceCode_h__
