// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_recognizer_h__
#define __c_recognizer_h__

#include "Puma/CScanBuffer.h"
#include "Puma/CCommentRecognizer.h"
#include "Puma/KeywordRecognizer.h"
#include "Puma/Array.h"

namespace Puma {


class CRecognizer {
  CScanBuffer scan_buffer;
  CCommentRecognizer comment_recognizer;
  Array<KeywordRecognizer*> additional_keyword_recognizers;

public:
  typedef enum { NORMAL, IN_COMP_DIR, IN_PRE_DIR } Mode;
  typedef enum { COMMENT, PRE_DIR, COMP_DIR, WHITE, PRE, STRING, CORE, 
                 KEYWORD, ID, WILDCARD, UNKNOWN } Lang;

  CRecognizer () : wildcards (false), aspectc (false), macro_ops (false),
    std_c (true), std_cplusplus (true) {}
  CRecognizer (ScanBuffer& buffer) : wildcards (false), aspectc (false),
    macro_ops (false) { setup (buffer); }
  void allow_wildcards (bool flag = true)     { wildcards = flag; }
  void allow_aspectc (bool flag = true)       { aspectc   = flag; } 
  void allow_macro_ops (bool flag = true)     { macro_ops = flag; }
  void allow_std_c (bool flag = true)         { std_c = flag; }
  void allow_std_cplusplus (bool flag = true) { std_cplusplus = flag; }
  void setup (ScanBuffer &buffer);
  int recognize (Lang &lang, int &expr, int &len);
  Mode mode () { return scan_mode; }
  bool new_line () const { return scan_buffer.new_line (); }
  CScanBuffer& buffer () { return scan_buffer; }
  void addRecognizer(KeywordRecognizer &recognizer) 
   { additional_keyword_recognizers.append(&recognizer); }

private:
  static MappedOrangeRecognizer<CScanBuffer> string_recognizer;   
  static MappedOrangeRecognizer<CScanBuffer> pre_dir_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> pre_token_recognizer;
  static OrangeRecognizer<CScanBuffer> dir_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> whitespace_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> wildcard_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> core_recognizer;
  static MappedOrangeRecognizer<CScanBuffer> identifier_recognizer;

  Mode scan_mode;
  bool check_directive;
  bool wildcards;
  bool aspectc;
  bool macro_ops;
  bool std_c;
  bool std_cplusplus;
};


} // namespace Puma

#endif /* __c_recognizer_h__ */
