// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTranslationUnit__
#define __CTranslationUnit__

#include "Puma/CClassDatabase.h"
#include "Puma/UnitManager.h"
#include "Puma/CProject.h"
#include "Puma/Builder.h"
#include "Puma/Unit.h"

namespace Puma {


class CTree;
class PreTree;

class CTranslationUnit {
  Unit *_unit;
  CTree *_syntax_tree;
  PreTree *_cpp_tree;
  CClassDatabase _class_db;
  UnitManager _local_units;

public:
  CTranslationUnit (Unit &u, CProject &p) :
    _unit (&u),
    _syntax_tree ((CTree*)0),
    _cpp_tree ((PreTree*)0),
    _class_db (p),
    _local_units (p.err ()) {}
  ~CTranslationUnit () 
    { destroy (_syntax_tree); destroy (_cpp_tree); }

  void tree (CTree *t) { _syntax_tree = t; }
  void cpp_tree (PreTree *t) { _cpp_tree = t; }

  CTree *tree () const { return _syntax_tree; }
  PreTree *cpp_tree () const { return _cpp_tree; }

  Unit *unit () const { return _unit; }
  CClassDatabase &db () const { return (CClassDatabase&)_class_db; }
  UnitManager &local_units () const { return (UnitManager&)_local_units; }

private:
  void destroy (CTree *t) { Builder::destroy(t); }
  void destroy (PreTree *);
};


} // namespace Puma

#endif /* __CTranslationUnit__ */
