// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/ErrorStream.h"
#include "Puma/Location.h"
#include <iostream>
using namespace std;

namespace Puma {


ErrorStream &ErrorStream::operator << (const char *v) {
  *_msg << v;
  return *this;
}


ErrorStream &ErrorStream::operator << (long v) {
  *_msg << v;
  return *this;
}


ErrorStream &ErrorStream::operator << (unsigned v) {
  *_msg << v;
  return *this;
}


ErrorStream &ErrorStream::operator << (int v) {
  *_msg << v;
  return *this;
}


ErrorStream &ErrorStream::operator << (short v) {
  *_msg << v;
  return *this;
}


ErrorStream &ErrorStream::operator << (char v) {
  *_msg << v;
  return *this;
}


ErrorStream &ErrorStream::operator << (double v) {
  *_msg << v;
  return *this;
}


ErrorStream &ErrorStream::operator << (const ErrorSeverity &sev) {
  _curr_severity = sev;
  if (_curr_severity > _max_severity)
    _max_severity = _curr_severity;
  return *this;
}


ErrorStream &ErrorStream::operator << (Location v) {
  _location      = v;
  _have_location = (v.filename().is_defined() && v.filename ().name ());
  return *this;
}


ErrorStream &ErrorStream::operator << (const Printable &v) {
  *_msg << v;
  return *this;
}


ErrorStream &ErrorStream::operator << (void (*f)(ErrorSink &)) {
  (*f) (*(ErrorSink*)this);
  return *this;
}


void ErrorStream::endMessage () {
  output ();
  clear ();
}


void ErrorStream::reset () {
  _max_severity = sev_none;
  clear ();
}


void ErrorStream::silent () {
  _silently = true;
}


void ErrorStream::loud () {
  _silently = false;
}


void ErrorStream::clear () {
  _curr_severity = sev_none;
  _have_location = false;
  if (_msg)
    delete _msg;
  _msg = new std::ostringstream;
}

   
void ErrorStream::output () {
  if (_silently) return;
   
  if (_have_location) 
    *_ostream << _location << ": ";

  if (_curr_severity != sev_none)
    *_ostream << _curr_severity.text () << ": ";

  *_ostream << _msg->str ().c_str () << endl;
}


} // namespace Puma
