// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __JoinPointPlan_h__
#define __JoinPointPlan_h__

#include "JPAdvice.h"
#include "AdviceInfo.h"
#include "OrderPlanner.h"
#include "CFlow.h"

#include "Puma/Array.h"
using namespace Puma;

namespace Puma {
  class ErrorSink;
  class CUnit;
  class ManipCommander;
  class ACAspectInfo;
  class ACSliceInfo;
} // namespace Puma

class Condition;
class LineDirectiveMgr;
class ACUnit;
class IntroductionUnit;

// abstract base of all join point plans
// (referenced by JoinPointLoc)

class JoinPointPlan : public OrderPlanner<ACAspectInfo> {

 public:
  virtual ~JoinPointPlan () {}

  // check the final plan for this join point -> false on error
  virtual bool check (ErrorSink &err) { return true; }
};

// base class of all plans for code join points
class JPP_Code : public JoinPointPlan {
  JPAdvice _jpa;
  Array<AdviceInfo*> _unsorted;
  Array<const Condition*> _conds;
  CFlowList _triggers;
  
 public:

  // get the join point advice tree structure
  JPAdvice *jp_advice () { return &_jpa; }

  // consider an advice in the plan for this code join point
  bool consider (AdviceInfo *ai, const Condition &cond);
  
  // consider a necessary cflow trigger at this join point
  bool consider (const CFlow &cflow) {
    _triggers.push_back (cflow);
    return true;
  }
  
  // return the list of cflows that must be entered/left here
  const CFlowList &cflows () const { return _triggers; }
  
  void issue (int index);

  bool check (ErrorSink &err);
};

class JPP_Class : public JoinPointPlan {
  Array<JPL_Introduction*> _base;
  Array<JPL_Introduction*> _other;
  Array<JPL_Introduction*> _unsorted;

  void gen_intro_inline (Unit *unit, JPL_Introduction *ii,
    ACSliceInfo *acsi, ErrorStream &err, LineDirectiveMgr &lmgr,
    CStructure *target) const;
  void gen_intro_non_inline (Unit *unit, JPL_Introduction *ii,
    ACSliceInfo *acsi, ErrorStream &err, LineDirectiveMgr &lmgr,
    CStructure *target) const;
  void gen_base_intro (IntroductionUnit &intro_unit,
    JPL_Introduction *ii, bool first) const;
  
  void instantiate_intro (ErrorStream &err, Unit *unit, CT_Intro *intro,
    const Unit &pattern, CStructure *target, Location &loc) const;
  
 public:
  // consider an introduction in the plan for this class join point
  bool consider (JPL_Introduction *ii);
  void issue (JPL_Introduction*ii);
  bool check(ErrorSink &err);

  int baseIntros () const { return _base.length (); }
  JPL_Introduction *baseIntro (int i) const { return _base.lookup (i); }

  int otherIntros () const { return _other.length (); }
  JPL_Introduction *otherIntro (int i) const { return _other.lookup (i); }

  void gen_intros (list<Unit*> &units, ErrorStream &err, 
    CStructure *target, LineDirectiveMgr &lmgr, bool non_inline = false) const;
  void gen_base_intros (list<Unit*> &units, ErrorStream &err,
    CClassInfo *target, LineDirectiveMgr &lmgr) const;
};

#endif // __JoinPointPlan_h__
