// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CEnumeratorInfo_h__
#define __CEnumeratorInfo_h__

// enumeration constant (enumerator) info
// knows its enumeration and its constant value

#include "Puma/CAttributeInfo.h"
#include "Puma/CTypeInfo.h"
#include "Puma/Limits.h"

namespace Puma {


class CEnumInfo;
class CT_Enumerator;
class CT_ExprList;

/** \file 
 *  Representation of an enumerator constant.
 *  \see Puma::CEnumeratorInfo */

/** \class CEnumeratorInfo CEnumeratorInfo.h Puma/infos/CEnumeratorInfo.h
 *  A CEnumeratorInfo object represents an enumerator constant. */
class CEnumeratorInfo : public CAttributeInfo {
  CEnumInfo *_Enum;
  LONG_LONG _Value;

public: 
  /** Construct a new enumerator info. */
  CEnumeratorInfo ();
  /** Destruct the enumerator info. If the object id is 
   *  \c ENUMERATOR_INFO, Puma::CObjectInfo::CleanUp() is called. */
  ~CEnumeratorInfo ();
  
  /** Get the base info object of the info object. <b>The 
   *  corresponding information is not yet set!</b>
   *  \return This method always returns \c NULL.
   *  \warning Do not use this method. */
  CEnumeratorInfo *BaseObject () const;
  /** Get the syntax tree node of the enumerator constant. */
  CT_Enumerator *Tree () const;
  /** Get the initialization expression syntax tree node of
   *  the enumerator. 
   *  \return The syntax tree node or \c NULL if no initializer. */
  CT_ExprList *Init () const;
  
  /** Get the underlying value type. */
  CTypeInfo *UnderlyingType () const;

  /** Get the corresponding enumeration info. */
  CEnumInfo *Enum () const;
  /** Set the enumeration info.
   *  \param ei The corresponding enumeration info. */
  void Enum (CEnumInfo *ei);

  /** Get the constant value of the enumerator. */
  LONG_LONG Value () const;
  /** Set the value of the enumerator constant. 
   *  \param v The value of the enumerator. */
  void Value (LONG_LONG v);
};

inline CEnumeratorInfo::CEnumeratorInfo () :
  CAttributeInfo (CObjectInfo::ENUMERATOR_INFO),
  _Enum ((CEnumInfo*)0),
  _Value (0)
 {}

inline void CEnumeratorInfo::Enum (CEnumInfo *e) 
 { _Enum = e; }
inline void CEnumeratorInfo::Value (LONG_LONG v) 
 { _Value = v; }

inline CEnumInfo *CEnumeratorInfo::Enum () const 
 { return _Enum; }
inline LONG_LONG CEnumeratorInfo::Value () const 
 { return _Value; }

inline CEnumeratorInfo *CEnumeratorInfo::BaseObject () const
 { return (CEnumeratorInfo*)CObjectInfo::BaseObject (); }

} // namespace Puma

#endif /* __CEnumeratorInfo_h__ */
