// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/ACSliceInfo.h"
#include "Puma/ACTree.h"
#include "Puma/CClassDatabase.h"

namespace Puma {

/** Desctructor: delete all pattern units */
ACSliceInfo::~ACSliceInfo () {
  if (_base_pattern) delete _base_pattern;
  if (_pattern) delete _pattern;
  for (int m = 0; m < members (); m++)
    delete _member_patterns[m];
}

ACSliceInfo::Type ACSliceInfo::type () const {
  if (!_def_node)
    return SL_UNKNOWN;
  switch (_def_node->key ()->token ()->type ()) {
    case TOK_UNION:  return SL_UNION;
    case TOK_STRUCT: return SL_STRUCT;
    case TOK_CLASS:  return SL_CLASS;
    case TOK_ASPECT: return SL_ASPECT;
    default:
      return SL_UNKNOWN;
  }
}

/** Set the slice definition syntax tree node.
 *  \param node The slice syntax tree node. */
void ACSliceInfo::def_node (CT_ClassSliceDecl *csd) {
  _def_node = csd;
  
  // create base clause pattern
  CT_Intro *intro = (CT_Intro*)csd->base_clause ();
  if (intro) {
    // create a unit for the baseclass pattern
    _base_pattern = new Unit;
    // set the name for #line directives
    _base_pattern->name (((Unit*)csd->token ()->belonging_to ())->name ());
    // copy all tokens
    for (int e = 1; e < intro->Entries (); e++) { // skip ":"
      Token *tok = intro->Entry (e)->token ();
      _base_pattern->append (*tok->duplicate ());
    }
  }
  
  // create pattern for inline members
  if (csd->members ()) {
    // create the unit
    _pattern = new Unit;
    // set the name for #line directives
    _pattern->name (((Unit*)csd->token ()->belonging_to ())->name ());
    for (int m = 0; m < csd->members ()->Entries (); m++) {
      CT_Intro *intro = (CT_Intro*)csd->members ()->Entry (m);
      for (int e = 0; e < intro->Entries (); e++) {
        Token *tok = intro->Entry (e)->token ();
        _pattern->append (*tok->duplicate ());
      }
    }
  }

}

/** Add a non-inline slice member.
 *  \param node The new member. */
void ACSliceInfo::add_member (CT_Intro *i) {
  _members.append (i);
  // create a unit for the baseclass pattern
  Unit *pattern = new Unit;
  // set the name for #line directives
  // TODO: think about slices generated by macros here
  Unit *ah_unit = (Unit*)i->token ()->belonging_to ();
  pattern->name (ah_unit->name ());
  // copy all tokens
  for (int e = 0; e < i->Entries (); e++) {
    Token *tok = i->Entry (e)->token ();
    pattern->append (*tok->duplicate ());
  }
  _member_patterns.append (pattern);
  _member_units.append (ah_unit);
}

ACSliceInfo *ACSliceInfo::definition () const {
  CObjectInfo *curr = _object;
  do {
    CT_ClassSliceDecl *csd = (CT_ClassSliceDecl*)curr->Tree ();
    if (csd->members () || csd->base_clause ())
      return curr->ClassDB ()->SliceInfo (curr);
    curr = curr->NextObject ();
  } while (curr != _object);
  return (ACSliceInfo*)0;
}

} // namespace Puma
