// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __error_collector_h__
#define __error_collector_h__

#include "Puma/ErrorSink.h"
#include "Puma/Array.h"
#include "Puma/Location.h"
#include "Puma/ErrorSeverity.h"
#include <sstream> 
using namespace std;

namespace Puma {


class ErrorCollector : public ErrorSink {
  class Msg {
    ErrorSeverity _sev;
    Location _loc;
    bool _have_loc;
    char *_msg;
 
  public:
    Msg (const ErrorSeverity &s, Location l, const char *m);
    Msg (const ErrorSeverity &s, const char *m);
    ~Msg ();
    bool operator == (const Msg&) const;
    void Shift (ErrorSink &e);
    const ErrorSeverity &severity () const { return _sev; }
  };

  Array<Msg*> _msgs;

  Location _loc;
  bool _have_loc;
  ErrorSeverity _sev;
  std::ostringstream _msg;

  void clear ();

public:
  ErrorCollector () { clear (); }
  virtual ~ErrorCollector () {}

  ErrorCollector& operator << (const char *);
  ErrorCollector& operator << (long);
  ErrorCollector& operator << (unsigned);
  ErrorCollector& operator << (int);
  ErrorCollector& operator << (short);
  ErrorCollector& operator << (char);
  ErrorCollector& operator << (double);
  ErrorCollector& operator << (const ErrorSeverity&);
  ErrorCollector& operator << (Location);
  ErrorCollector& operator << (const Printable&);
  ErrorCollector& operator << (void (*f)(ErrorSink&));
 
  void endMessage ();

  int index ();
  void index (int n);
  void Shift (ErrorSink &e);

  const ErrorSeverity &severity () const;
};
  

} // namespace Puma

#endif /* __error_collector_h__ */
