/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.build;

import java.util.List;
import java.util.ListIterator;
import org.aspectj.internal.tools.build.Sample;
import org.aspectj.internal.tools.build.SampleUtil;
import org.aspectj.internal.tools.build.Samples;

class SamplesRenderer {
    public static SamplesRenderer ME = new SamplesRenderer();
    public static final String EOL = "\n";
    public static final String INFO = "<p>This contains contributions from the AspectJ community of <ul><li>sample code for AspectJ programs,</li><li>sample code for extensions to AspectJ tools using the public API's,</li><li>sample scripts for invoking AspectJ tools, and </li> <li>documentation trails showing how to do given tasks    using AspectJ, AJDT, or various IDE or deployment    environments.</li></ul></p><p>Find complete source files in the AspectJ CVS repository at <code>org.aspectj/modules/docs/sandbox</code>. For instructions on downloading code from the CVS repository, see the <a href=\"doc/faq.html#q:buildingsource\">FAQ entry \"buildingsource\"</a>.</p>";
    public static final String COPYRIGHT = "<p><small>Copyright 2003 Contributors. All Rights Reserved. This sample code is made available under the Common Public License version 1.0 available at <a href=\"http://www.eclipse.org/legal/epl-v10.html\">http://www.eclipse.org/legal/epl-v10.html</a>.Contributors are listed in this document as authors. Permission to republish portions of this sample code is hereby granted if the publication acknowledges the author by name and the source by reference to the AspectJ project home page  at http://eclipse.org/aspectj.</small></p>\n";

    protected SamplesRenderer() {
    }

    public final StringBuffer render(Samples samples, StringBuffer sink) {
        if (null == sink) {
            sink = new StringBuffer();
        }
        if (null == samples || 0 == samples.size()) {
            return sink;
        }
        this.startList(samples, sink);
        List<Sample> list = samples.getSortedSamples();
        String anchorName = null;
        ListIterator<Sample> iter = list.listIterator();
        while (iter.hasNext()) {
            Sample sample = iter.next();
            String newAnchorName = sample.anchorName;
            if (null == anchorName || !anchorName.equals(newAnchorName)) {
                this.endAnchorName(anchorName, sink);
                this.startAnchorName(newAnchorName, sample.anchorTitle, sink);
                anchorName = newAnchorName;
            }
            this.render(sample, sink);
        }
        this.endAnchorName(anchorName, sink);
        this.endList(samples, sink);
        return sink;
    }

    protected void startList(Samples samples, StringBuffer sink) {
        sink.append("Printing " + samples.size() + " samples");
        sink.append(EOL);
    }

    protected void startAnchorName(String name, String title, StringBuffer sink) {
        sink.append("anchor " + name);
        sink.append(EOL);
    }

    protected void render(Sample sample, StringBuffer sink) {
        SampleUtil.render(sample, "=", ", ", sink);
        sink.setLength(sink.length() - 2);
        sink.append(EOL);
    }

    protected void endAnchorName(String name, StringBuffer sink) {
        if (null == name) {
            return;
        }
    }

    protected void endList(Samples samples, StringBuffer sink) {
        sink.append("Printed " + samples.size() + " samples");
        sink.append(EOL);
    }
}

